/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.credential;

import com.google.common.base.Preconditions;
import java.util.Set;
import javax.validation.constraints.NotNull;
import org.apache.gravitino.credential.CredentialContext;

public class PathBasedCredentialContext
implements CredentialContext {
    @NotNull
    private final Set<String> writePaths;
    @NotNull
    private final Set<String> readPaths;
    @NotNull
    private final String userName;

    public PathBasedCredentialContext(String userName, Set<String> writePaths, Set<String> readPaths) {
        Preconditions.checkNotNull((Object)userName, (Object)"User name should not be null");
        Preconditions.checkNotNull(writePaths, (Object)"Write paths should not be null");
        Preconditions.checkNotNull(readPaths, (Object)"Read paths should not be null");
        this.userName = userName;
        this.writePaths = writePaths;
        this.readPaths = readPaths;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    public Set<String> getWritePaths() {
        return this.writePaths;
    }

    public Set<String> getReadPaths() {
        return this.readPaths;
    }
}

