/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.kv;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.gravitino.Config;
import org.apache.gravitino.Configs;
import org.apache.gravitino.storage.TransactionIdGenerator;
import org.apache.gravitino.storage.kv.KvBackend;
import org.apache.gravitino.utils.ByteUtils;
import org.apache.gravitino.utils.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionIdGeneratorImpl
implements TransactionIdGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransactionIdGeneratorImpl.class);
    private final KvBackend kvBackend;
    private static final byte[] ID_GENERATOR_PREFIX = new byte[]{29, 0, 1};
    static final byte[] LAST_TIMESTAMP = Bytes.concat(ID_GENERATOR_PREFIX, "last_timestamp".getBytes(StandardCharsets.UTF_8));
    private volatile long incrementId = 0L;
    private volatile long lastTransactionId = 0L;
    private final Config config;
    private final ScheduledExecutorService scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("TransactionIdGenerator-thread-%d").setUncaughtExceptionHandler((t, e) -> LOGGER.error("Uncaught exception in thread {}", (Object)t, (Object)e)).build());

    public TransactionIdGeneratorImpl(KvBackend kvBackend, Config config) {
        this.kvBackend = kvBackend;
        this.config = config;
    }

    @Override
    public void start() {
        long maxSkewTime = this.config.get(Configs.STORE_TRANSACTION_MAX_SKEW_TIME);
        this.checkTimeSkew(maxSkewTime + 1000L);
        this.scheduledThreadPoolExecutor.scheduleAtFixedRate(() -> {
            int i = 0;
            while (i++ < 3) {
                try {
                    this.kvBackend.put(LAST_TIMESTAMP, ByteUtils.longToByte(System.currentTimeMillis()), true);
                    return;
                }
                catch (IOException e) {
                    LOGGER.warn("Failed to save current timestamp to storage layer, retrying...", (Throwable)e);
                }
            }
            throw new RuntimeException("Failed to save current timestamp to storage layer after 3 retries, please checkwhether the storage layer is healthy.");
        }, maxSkewTime * 2L, maxSkewTime, TimeUnit.MILLISECONDS);
    }

    private void checkTimeSkew(long maxSkewTimeInMs) {
        long current = System.currentTimeMillis();
        try {
            long old = this.getSavedTs();
            int retries = 0;
            while (current <= old + maxSkewTimeInMs && (long)retries++ < maxSkewTimeInMs / 100L) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException("Thread was interrupted, exception: ", e);
                }
                current = System.currentTimeMillis();
            }
            if (current <= old + maxSkewTimeInMs) {
                throw new RuntimeException(String.format("Failed to initialize transaction id generator after %d milliseconds, time skew is too large", maxSkewTimeInMs));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private long getSavedTs() throws IOException {
        byte[] oldIdBytes = this.kvBackend.get(LAST_TIMESTAMP);
        return oldIdBytes == null ? 0L : ByteUtils.byteToLong(oldIdBytes);
    }

    @Override
    public synchronized long nextId() {
        long tmpId;
        ++this.incrementId;
        if (this.incrementId >= 262143L) {
            this.incrementId = 0L;
        }
        while ((tmpId = (System.currentTimeMillis() << 18) + this.incrementId) <= this.lastTransactionId) {
        }
        this.lastTransactionId = tmpId;
        return tmpId;
    }

    @Override
    public void close() throws IOException {
        this.scheduledThreadPoolExecutor.shutdownNow();
        try {
            this.scheduledThreadPoolExecutor.awaitTermination(2000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.warn("Failed to close thread pool scheduledThreadPoolExecutor in TransactionIdGeneratorImpl with in 2000 milliseconds", (Throwable)e);
        }
    }
}

