/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.authorization;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.Entity;
import org.apache.gravitino.EntityStore;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.authorization.AuthorizationUtils;
import org.apache.gravitino.authorization.Group;
import org.apache.gravitino.authorization.Privilege;
import org.apache.gravitino.authorization.Role;
import org.apache.gravitino.authorization.RoleChange;
import org.apache.gravitino.authorization.RoleManager;
import org.apache.gravitino.authorization.SecurableObject;
import org.apache.gravitino.authorization.SecurableObjects;
import org.apache.gravitino.authorization.User;
import org.apache.gravitino.exceptions.IllegalRoleException;
import org.apache.gravitino.exceptions.NoSuchEntityException;
import org.apache.gravitino.exceptions.NoSuchGroupException;
import org.apache.gravitino.exceptions.NoSuchRoleException;
import org.apache.gravitino.exceptions.NoSuchUserException;
import org.apache.gravitino.meta.AuditInfo;
import org.apache.gravitino.meta.GroupEntity;
import org.apache.gravitino.meta.RoleEntity;
import org.apache.gravitino.meta.UserEntity;
import org.apache.gravitino.utils.PrincipalUtils;
import org.glassfish.jersey.internal.guava.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PermissionManager {
    private static final Logger LOG = LoggerFactory.getLogger(PermissionManager.class);
    private final EntityStore store;
    private final RoleManager roleManager;

    PermissionManager(EntityStore store, RoleManager roleManager) {
        this.store = store;
        this.roleManager = roleManager;
    }

    User grantRolesToUser(String metalake, List<String> roles, String user) {
        try {
            ArrayList roleEntitiesToGrant = Lists.newArrayList();
            for (String role : roles) {
                roleEntitiesToGrant.add(this.roleManager.getRole(metalake, role));
            }
            User updatedUser = this.store.update(AuthorizationUtils.ofUser(metalake, user), UserEntity.class, Entity.EntityType.USER, userEntity -> {
                ArrayList roleEntities = Lists.newArrayList();
                if (userEntity.roleNames() != null) {
                    for (String role : userEntity.roleNames()) {
                        roleEntities.add(this.roleManager.getRole(metalake, role));
                    }
                }
                ArrayList roleNames = Lists.newArrayList(this.toRoleNames(roleEntities));
                ArrayList roleIds = Lists.newArrayList(this.toRoleIds(roleEntities));
                for (RoleEntity roleEntityToGrant : roleEntitiesToGrant) {
                    if (roleIds.contains(roleEntityToGrant.id())) {
                        LOG.warn("Failed to grant, role {} already exists in the user {} of metalake {}", new Object[]{roleEntityToGrant.name(), user, metalake});
                        continue;
                    }
                    roleNames.add(roleEntityToGrant.name());
                    roleIds.add(roleEntityToGrant.id());
                }
                AuditInfo auditInfo = AuditInfo.builder().withCreator(userEntity.auditInfo().creator()).withCreateTime(userEntity.auditInfo().createTime()).withLastModifier(PrincipalUtils.getCurrentPrincipal().getName()).withLastModifiedTime(Instant.now()).build();
                return UserEntity.builder().withNamespace(userEntity.namespace()).withId(userEntity.id()).withName(userEntity.name()).withRoleNames(roleNames).withRoleIds(roleIds).withAuditInfo(auditInfo).build();
            });
            HashSet catalogs = Sets.newHashSet();
            for (Role grantedRole : roleEntitiesToGrant) {
                AuthorizationUtils.callAuthorizationPluginForSecurableObjects(metalake, grantedRole.securableObjects(), catalogs, authorizationPlugin -> authorizationPlugin.onGrantedRolesToUser(Lists.newArrayList((Iterable)roleEntitiesToGrant), updatedUser));
            }
            return updatedUser;
        }
        catch (NoSuchEntityException nse) {
            LOG.warn("Failed to grant, user {} does not exist in the metalake {}", new Object[]{user, metalake, nse});
            throw new NoSuchUserException("User %s does not exist in the metalake %s", new Object[]{user, metalake});
        }
        catch (NoSuchRoleException nsr) {
            throw new IllegalRoleException((Throwable)nsr);
        }
        catch (IOException ioe) {
            LOG.error("Failed to grant role {} to user {} in the metalake {} due to storage issues", new Object[]{StringUtils.join(roles, (String)","), user, metalake, ioe});
            throw new RuntimeException(ioe);
        }
    }

    Group grantRolesToGroup(String metalake, List<String> roles, String group) {
        try {
            ArrayList roleEntitiesToGrant = Lists.newArrayList();
            for (String role : roles) {
                roleEntitiesToGrant.add(this.roleManager.getRole(metalake, role));
            }
            Group updatedGroup = this.store.update(AuthorizationUtils.ofGroup(metalake, group), GroupEntity.class, Entity.EntityType.GROUP, groupEntity -> {
                ArrayList roleEntities = Lists.newArrayList();
                if (groupEntity.roleNames() != null) {
                    for (String role : groupEntity.roleNames()) {
                        roleEntities.add(this.roleManager.getRole(metalake, role));
                    }
                }
                ArrayList roleNames = Lists.newArrayList(this.toRoleNames(roleEntities));
                ArrayList roleIds = Lists.newArrayList(this.toRoleIds(roleEntities));
                for (RoleEntity roleEntityToGrant : roleEntitiesToGrant) {
                    if (roleIds.contains(roleEntityToGrant.id())) {
                        LOG.warn("Failed to grant, role {} already exists in the group {} of metalake {}", new Object[]{roleEntityToGrant.name(), group, metalake});
                        continue;
                    }
                    roleNames.add(roleEntityToGrant.name());
                    roleIds.add(roleEntityToGrant.id());
                }
                AuditInfo auditInfo = AuditInfo.builder().withCreator(groupEntity.auditInfo().creator()).withCreateTime(groupEntity.auditInfo().createTime()).withLastModifier(PrincipalUtils.getCurrentPrincipal().getName()).withLastModifiedTime(Instant.now()).build();
                return GroupEntity.builder().withId(groupEntity.id()).withNamespace(groupEntity.namespace()).withName(groupEntity.name()).withRoleNames(roleNames).withRoleIds(roleIds).withAuditInfo(auditInfo).build();
            });
            HashSet catalogs = Sets.newHashSet();
            for (Role grantedRole : roleEntitiesToGrant) {
                AuthorizationUtils.callAuthorizationPluginForSecurableObjects(metalake, grantedRole.securableObjects(), catalogs, authorizationPlugin -> authorizationPlugin.onGrantedRolesToGroup(Lists.newArrayList((Iterable)roleEntitiesToGrant), updatedGroup));
            }
            return updatedGroup;
        }
        catch (NoSuchEntityException nse) {
            LOG.warn("Failed to grant, group {} does not exist in the metalake {}", new Object[]{group, metalake, nse});
            throw new NoSuchGroupException("Group %s does not exist in the metalake %s", new Object[]{group, metalake});
        }
        catch (NoSuchRoleException nsr) {
            throw new IllegalRoleException((Throwable)nsr);
        }
        catch (IOException ioe) {
            LOG.error("Failed to grant role {} to group {} in the metalake {} due to storage issues", new Object[]{StringUtils.join(roles, (String)","), group, metalake, ioe});
            throw new RuntimeException(ioe);
        }
    }

    Group revokeRolesFromGroup(String metalake, List<String> roles, String group) {
        try {
            ArrayList roleEntitiesToRevoke = Lists.newArrayList();
            for (String role : roles) {
                roleEntitiesToRevoke.add(this.roleManager.getRole(metalake, role));
            }
            Group updatedGroup = this.store.update(AuthorizationUtils.ofGroup(metalake, group), GroupEntity.class, Entity.EntityType.GROUP, groupEntity -> {
                ArrayList roleEntities = Lists.newArrayList();
                if (groupEntity.roleNames() != null) {
                    for (String role : groupEntity.roleNames()) {
                        roleEntities.add(this.roleManager.getRole(metalake, role));
                    }
                }
                ArrayList roleNames = Lists.newArrayList(this.toRoleNames(roleEntities));
                ArrayList roleIds = Lists.newArrayList(this.toRoleIds(roleEntities));
                for (RoleEntity roleEntityToRevoke : roleEntitiesToRevoke) {
                    roleNames.remove(roleEntityToRevoke.name());
                    boolean removed = roleIds.remove(roleEntityToRevoke.id());
                    if (removed) continue;
                    LOG.warn("Failed to revoke, role {} does not exist in the group {} of metalake {}", new Object[]{roleEntityToRevoke.name(), group, metalake});
                }
                AuditInfo auditInfo = AuditInfo.builder().withCreator(groupEntity.auditInfo().creator()).withCreateTime(groupEntity.auditInfo().createTime()).withLastModifier(PrincipalUtils.getCurrentPrincipal().getName()).withLastModifiedTime(Instant.now()).build();
                return GroupEntity.builder().withNamespace(groupEntity.namespace()).withId(groupEntity.id()).withName(groupEntity.name()).withRoleNames(roleNames).withRoleIds(roleIds).withAuditInfo(auditInfo).build();
            });
            HashSet catalogs = Sets.newHashSet();
            for (Role grantedRole : roleEntitiesToRevoke) {
                AuthorizationUtils.callAuthorizationPluginForSecurableObjects(metalake, grantedRole.securableObjects(), catalogs, authorizationPlugin -> authorizationPlugin.onRevokedRolesFromGroup(Lists.newArrayList((Iterable)roleEntitiesToRevoke), updatedGroup));
            }
            return updatedGroup;
        }
        catch (NoSuchEntityException nse) {
            LOG.warn("Failed to revoke, group {} does not exist in the metalake {}", new Object[]{group, metalake, nse});
            throw new NoSuchGroupException("Group %s does not exist in the metalake %s", new Object[]{group, metalake});
        }
        catch (NoSuchRoleException nsr) {
            throw new IllegalRoleException((Throwable)nsr);
        }
        catch (IOException ioe) {
            LOG.error("Failed to revoke role {} from  group {} in the metalake {} due to storage issues", new Object[]{StringUtils.join(roles, (String)","), group, metalake, ioe});
            throw new RuntimeException(ioe);
        }
    }

    User revokeRolesFromUser(String metalake, List<String> roles, String user) {
        try {
            ArrayList roleEntitiesToRevoke = Lists.newArrayList();
            for (String role : roles) {
                roleEntitiesToRevoke.add(this.roleManager.getRole(metalake, role));
            }
            User updatedUser = this.store.update(AuthorizationUtils.ofUser(metalake, user), UserEntity.class, Entity.EntityType.USER, userEntity -> {
                ArrayList roleEntities = Lists.newArrayList();
                if (userEntity.roleNames() != null) {
                    for (String role : userEntity.roleNames()) {
                        roleEntities.add(this.roleManager.getRole(metalake, role));
                    }
                }
                ArrayList roleNames = Lists.newArrayList(this.toRoleNames(roleEntities));
                ArrayList roleIds = Lists.newArrayList(this.toRoleIds(roleEntities));
                for (RoleEntity roleEntityToRevoke : roleEntitiesToRevoke) {
                    roleNames.remove(roleEntityToRevoke.name());
                    boolean removed = roleIds.remove(roleEntityToRevoke.id());
                    if (removed) continue;
                    LOG.warn("Failed to revoke, role {} doesn't exist in the user {} of metalake {}", new Object[]{roleEntityToRevoke.name(), user, metalake});
                }
                AuditInfo auditInfo = AuditInfo.builder().withCreator(userEntity.auditInfo().creator()).withCreateTime(userEntity.auditInfo().createTime()).withLastModifier(PrincipalUtils.getCurrentPrincipal().getName()).withLastModifiedTime(Instant.now()).build();
                return UserEntity.builder().withId(userEntity.id()).withNamespace(userEntity.namespace()).withName(userEntity.name()).withRoleNames(roleNames).withRoleIds(roleIds).withAuditInfo(auditInfo).build();
            });
            HashSet catalogs = Sets.newHashSet();
            for (Role grantedRole : roleEntitiesToRevoke) {
                AuthorizationUtils.callAuthorizationPluginForSecurableObjects(metalake, grantedRole.securableObjects(), catalogs, authorizationPlugin -> authorizationPlugin.onRevokedRolesFromUser(Lists.newArrayList((Iterable)roleEntitiesToRevoke), updatedUser));
            }
            return updatedUser;
        }
        catch (NoSuchEntityException nse) {
            LOG.warn("Failed to revoke, user {} does not exist in the metalake {}", new Object[]{user, metalake, nse});
            throw new NoSuchUserException("User %s does not exist in the metalake %s", new Object[]{user, metalake});
        }
        catch (NoSuchRoleException nsr) {
            throw new IllegalRoleException((Throwable)nsr);
        }
        catch (IOException ioe) {
            LOG.error("Failed to revoke role {} from  user {} in the metalake {} due to storage issues", new Object[]{StringUtils.join(roles, (String)","), user, metalake, ioe});
            throw new RuntimeException(ioe);
        }
    }

    Role grantPrivilegesToRole(String metalake, String role, MetadataObject object, List<Privilege> privileges) {
        try {
            AuthorizationPluginCallbackWrapper authorizationPluginCallbackWrapper = new AuthorizationPluginCallbackWrapper();
            Role updatedRole = this.store.update(AuthorizationUtils.ofRole(metalake, role), RoleEntity.class, Entity.EntityType.ROLE, roleEntity -> {
                List<SecurableObject> grantedSecurableObjects = this.generateNewSecurableObjects(roleEntity.securableObjects(), object, targetObject -> {
                    if (targetObject == null) {
                        return PermissionManager.createNewSecurableObject(metalake, role, object, privileges, roleEntity, authorizationPluginCallbackWrapper);
                    }
                    return PermissionManager.updateGrantedSecurableObject(metalake, role, object, privileges, roleEntity, targetObject, authorizationPluginCallbackWrapper);
                });
                AuditInfo auditInfo = AuditInfo.builder().withCreator(roleEntity.auditInfo().creator()).withCreateTime(roleEntity.auditInfo().createTime()).withLastModifier(PrincipalUtils.getCurrentPrincipal().getName()).withLastModifiedTime(Instant.now()).build();
                return RoleEntity.builder().withId(roleEntity.id()).withName(roleEntity.name()).withNamespace(roleEntity.namespace()).withProperties(roleEntity.properties()).withAuditInfo(auditInfo).withSecurableObjects(grantedSecurableObjects).build();
            });
            authorizationPluginCallbackWrapper.execute();
            return updatedRole;
        }
        catch (NoSuchEntityException nse) {
            LOG.error("Failed to grant, role {} does not exist in the metalake {}", new Object[]{role, metalake, nse});
            throw new NoSuchRoleException("Role %s does not exist in the metalake %s", new Object[]{role, metalake});
        }
        catch (IOException ioe) {
            LOG.error("Grant privileges to {} failed due to storage issues", (Object)role, (Object)ioe);
            throw new RuntimeException(ioe);
        }
    }

    private static SecurableObject updateGrantedSecurableObject(String metalake, String role, MetadataObject object, List<Privilege> privileges, RoleEntity roleEntity, SecurableObject targetObject, AuthorizationPluginCallbackWrapper authorizationPluginCallbackWrapper) {
        HashSet updatePrivileges = Sets.newHashSet();
        updatePrivileges.addAll(targetObject.privileges());
        if (updatePrivileges.containsAll(privileges)) {
            return targetObject;
        }
        updatePrivileges.addAll(privileges);
        AuthorizationUtils.checkDuplicatedNamePrivilege(privileges);
        SecurableObject newSecurableObject = SecurableObjects.parse((String)targetObject.fullName(), (MetadataObject.Type)targetObject.type(), (List)Lists.newArrayList((Iterable)updatePrivileges));
        authorizationPluginCallbackWrapper.setCallback(() -> AuthorizationUtils.callAuthorizationPluginForMetadataObject(metalake, object, authorizationPlugin -> authorizationPlugin.onRoleUpdated(roleEntity, RoleChange.updateSecurableObject((String)role, (SecurableObject)targetObject, (SecurableObject)newSecurableObject))));
        return newSecurableObject;
    }

    Role revokePrivilegesFromRole(String metalake, String role, MetadataObject object, List<Privilege> privileges) {
        try {
            AuthorizationPluginCallbackWrapper authorizationCallbackWrapper = new AuthorizationPluginCallbackWrapper();
            RoleEntity updatedRole = this.store.update(AuthorizationUtils.ofRole(metalake, role), RoleEntity.class, Entity.EntityType.ROLE, roleEntity -> {
                List<SecurableObject> revokedSecurableObjects = this.generateNewSecurableObjects(roleEntity.securableObjects(), object, targetObject -> {
                    if (targetObject == null) {
                        LOG.warn("Securable object {} type {} doesn't exist in the role {}", new Object[]{object.fullName(), object.type(), role});
                        return null;
                    }
                    return PermissionManager.updateRevokedSecurableObject(metalake, role, object, privileges, roleEntity, targetObject, authorizationCallbackWrapper);
                });
                AuditInfo auditInfo = AuditInfo.builder().withCreator(roleEntity.auditInfo().creator()).withCreateTime(roleEntity.auditInfo().createTime()).withLastModifier(PrincipalUtils.getCurrentPrincipal().getName()).withLastModifiedTime(Instant.now()).build();
                return RoleEntity.builder().withId(roleEntity.id()).withName(roleEntity.name()).withNamespace(roleEntity.namespace()).withProperties(roleEntity.properties()).withAuditInfo(auditInfo).withSecurableObjects(revokedSecurableObjects).build();
            });
            authorizationCallbackWrapper.execute();
            return updatedRole;
        }
        catch (NoSuchEntityException nse) {
            LOG.error("Failed to revoke, role {} does not exist in the metalake {}", new Object[]{role, metalake, nse});
            throw new NoSuchRoleException("Role %s does not exist in the metalake %s", new Object[]{role, metalake});
        }
        catch (IOException ioe) {
            LOG.error("Revoke privileges from {} failed due to storage issues", (Object)role, (Object)ioe);
            throw new RuntimeException(ioe);
        }
    }

    private static SecurableObject createNewSecurableObject(String metalake, String role, MetadataObject object, List<Privilege> privileges, RoleEntity roleEntity, AuthorizationPluginCallbackWrapper authorizationPluginCallbackWrapper) {
        SecurableObject securableObject = SecurableObjects.parse((String)object.fullName(), (MetadataObject.Type)object.type(), (List)Lists.newArrayList(privileges));
        authorizationPluginCallbackWrapper.setCallback(() -> AuthorizationUtils.callAuthorizationPluginForMetadataObject(metalake, object, authorizationPlugin -> authorizationPlugin.onRoleUpdated(roleEntity, RoleChange.addSecurableObject((String)role, (SecurableObject)securableObject))));
        return securableObject;
    }

    private static SecurableObject updateRevokedSecurableObject(String metalake, String role, MetadataObject object, List<Privilege> privileges, RoleEntity roleEntity, SecurableObject targetObject, AuthorizationPluginCallbackWrapper authorizationCallbackWrapper) {
        HashSet updatePrivileges = Sets.newHashSet();
        updatePrivileges.addAll(targetObject.privileges());
        privileges.forEach(updatePrivileges::remove);
        if (!updatePrivileges.isEmpty()) {
            SecurableObject newSecurableObject = SecurableObjects.parse((String)targetObject.fullName(), (MetadataObject.Type)targetObject.type(), (List)Lists.newArrayList((Iterable)updatePrivileges));
            authorizationCallbackWrapper.setCallback(() -> AuthorizationUtils.callAuthorizationPluginForMetadataObject(metalake, object, authorizationPlugin -> authorizationPlugin.onRoleUpdated(roleEntity, RoleChange.updateSecurableObject((String)role, (SecurableObject)targetObject, (SecurableObject)newSecurableObject))));
            return newSecurableObject;
        }
        authorizationCallbackWrapper.setCallback(() -> AuthorizationUtils.callAuthorizationPluginForMetadataObject(metalake, object, authorizationPlugin -> authorizationPlugin.onRoleUpdated(roleEntity, RoleChange.removeSecurableObject((String)role, (SecurableObject)targetObject))));
        return null;
    }

    private List<SecurableObject> generateNewSecurableObjects(List<SecurableObject> securableObjects, MetadataObject targetObject, Function<SecurableObject, SecurableObject> objectUpdater) {
        SecurableObject newSecurableObject;
        ArrayList updateSecurableObjects = Lists.newArrayList(securableObjects);
        SecurableObject matchedSecurableObject = securableObjects.stream().filter(targetObject::equals).findFirst().orElse(null);
        if (matchedSecurableObject != null) {
            updateSecurableObjects.remove(matchedSecurableObject);
        }
        if ((newSecurableObject = objectUpdater.apply(matchedSecurableObject)) != null) {
            updateSecurableObjects.add(newSecurableObject);
        }
        return updateSecurableObjects;
    }

    private List<Long> toRoleIds(List<RoleEntity> roleEntities) {
        return roleEntities.stream().map(RoleEntity::id).collect(Collectors.toList());
    }

    private List<String> toRoleNames(List<RoleEntity> roleEntities) {
        return roleEntities.stream().map(RoleEntity::name).collect(Collectors.toList());
    }

    private static class AuthorizationPluginCallbackWrapper {
        private Runnable callback;

        private AuthorizationPluginCallbackWrapper() {
        }

        public void setCallback(Runnable callback) {
            this.callback = callback;
        }

        public void execute() {
            if (this.callback != null) {
                this.callback.run();
            }
        }
    }
}

