/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.po;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;

public class TagPO {
    private Long tagId;
    private String tagName;
    private Long metalakeId;
    private String comment;
    private String properties;
    private String auditInfo;
    private Long currentVersion;
    private Long lastVersion;
    private Long deletedAt;

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TagPO)) {
            return false;
        }
        TagPO tagPO = (TagPO)o;
        return Objects.equal((Object)this.tagId, (Object)tagPO.tagId) && Objects.equal((Object)this.tagName, (Object)tagPO.tagName) && Objects.equal((Object)this.metalakeId, (Object)tagPO.metalakeId) && Objects.equal((Object)this.comment, (Object)tagPO.comment) && Objects.equal((Object)this.properties, (Object)tagPO.properties) && Objects.equal((Object)this.auditInfo, (Object)tagPO.auditInfo) && Objects.equal((Object)this.currentVersion, (Object)tagPO.currentVersion) && Objects.equal((Object)this.lastVersion, (Object)tagPO.lastVersion) && Objects.equal((Object)this.deletedAt, (Object)tagPO.deletedAt);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.tagId, this.tagName, this.metalakeId, this.comment, this.properties, this.auditInfo, this.currentVersion, this.lastVersion, this.deletedAt});
    }

    public Long getTagId() {
        return this.tagId;
    }

    public String getTagName() {
        return this.tagName;
    }

    public Long getMetalakeId() {
        return this.metalakeId;
    }

    public String getComment() {
        return this.comment;
    }

    public String getProperties() {
        return this.properties;
    }

    public String getAuditInfo() {
        return this.auditInfo;
    }

    public Long getCurrentVersion() {
        return this.currentVersion;
    }

    public Long getLastVersion() {
        return this.lastVersion;
    }

    public Long getDeletedAt() {
        return this.deletedAt;
    }

    public static class Builder {
        private final TagPO tagPO = new TagPO();

        private Builder() {
        }

        public Builder withTagId(Long tagId) {
            this.tagPO.tagId = tagId;
            return this;
        }

        public Builder withTagName(String tagName) {
            this.tagPO.tagName = tagName;
            return this;
        }

        public Builder withMetalakeId(Long metalakeId) {
            this.tagPO.metalakeId = metalakeId;
            return this;
        }

        public Builder withComment(String comment) {
            this.tagPO.comment = comment;
            return this;
        }

        public Builder withProperties(String properties) {
            this.tagPO.properties = properties;
            return this;
        }

        public Builder withAuditInfo(String auditInfo) {
            this.tagPO.auditInfo = auditInfo;
            return this;
        }

        public Builder withCurrentVersion(Long currentVersion) {
            this.tagPO.currentVersion = currentVersion;
            return this;
        }

        public Builder withLastVersion(Long lastVersion) {
            this.tagPO.lastVersion = lastVersion;
            return this;
        }

        public Builder withDeletedAt(Long deletedAt) {
            this.tagPO.deletedAt = deletedAt;
            return this;
        }

        public TagPO build() {
            this.validate();
            return this.tagPO;
        }

        private void validate() {
            Preconditions.checkArgument((this.tagPO.tagId != null ? 1 : 0) != 0, (Object)"tagId cannot be null");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.tagPO.tagName), (Object)"tagName cannot be empty");
            Preconditions.checkArgument((this.tagPO.metalakeId != null ? 1 : 0) != 0, (Object)"metalakeId cannot be null");
            Preconditions.checkArgument((this.tagPO.auditInfo != null ? 1 : 0) != 0, (Object)"auditInfo cannot be null");
            Preconditions.checkArgument((this.tagPO.currentVersion != null ? 1 : 0) != 0, (Object)"currentVersion cannot be null");
            Preconditions.checkArgument((this.tagPO.lastVersion != null ? 1 : 0) != 0, (Object)"lastVersion cannot be null");
            Preconditions.checkArgument((this.tagPO.deletedAt != null ? 1 : 0) != 0, (Object)"deletedAt cannot be null");
        }
    }
}

