/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.service;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.apache.gravitino.Entity;
import org.apache.gravitino.HasIdentifier;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.exceptions.NoSuchEntityException;
import org.apache.gravitino.meta.TopicEntity;
import org.apache.gravitino.storage.relational.mapper.OwnerMetaMapper;
import org.apache.gravitino.storage.relational.mapper.TopicMetaMapper;
import org.apache.gravitino.storage.relational.po.TopicPO;
import org.apache.gravitino.storage.relational.service.CatalogMetaService;
import org.apache.gravitino.storage.relational.service.CommonMetaService;
import org.apache.gravitino.storage.relational.service.MetalakeMetaService;
import org.apache.gravitino.storage.relational.service.SchemaMetaService;
import org.apache.gravitino.storage.relational.utils.ExceptionUtils;
import org.apache.gravitino.storage.relational.utils.POConverters;
import org.apache.gravitino.storage.relational.utils.SessionUtils;
import org.apache.gravitino.utils.NameIdentifierUtil;
import org.apache.gravitino.utils.NamespaceUtil;

public class TopicMetaService {
    private static final TopicMetaService INSTANCE = new TopicMetaService();

    public static TopicMetaService getInstance() {
        return INSTANCE;
    }

    private TopicMetaService() {
    }

    public void insertTopic(TopicEntity topicEntity, boolean overwrite) throws IOException {
        try {
            NameIdentifierUtil.checkTopic(topicEntity.nameIdentifier());
            TopicPO.Builder builder = TopicPO.builder();
            this.fillTopicPOBuilderParentEntityId(builder, topicEntity.namespace());
            SessionUtils.doWithCommit(TopicMetaMapper.class, mapper -> {
                TopicPO po = POConverters.initializeTopicPOWithVersion(topicEntity, builder);
                if (overwrite) {
                    mapper.insertTopicMetaOnDuplicateKeyUpdate(po);
                } else {
                    mapper.insertTopicMeta(po);
                }
            });
        }
        catch (RuntimeException re) {
            ExceptionUtils.checkSQLException(re, Entity.EntityType.TOPIC, topicEntity.nameIdentifier().toString());
            throw re;
        }
    }

    public List<TopicEntity> listTopicsByNamespace(Namespace namespace) {
        NamespaceUtil.checkTopic(namespace);
        Long schemaId = CommonMetaService.getInstance().getParentEntityIdByNamespace(namespace);
        List topicPOs = SessionUtils.getWithoutCommit(TopicMetaMapper.class, mapper -> mapper.listTopicPOsBySchemaId(schemaId));
        return POConverters.fromTopicPOs(topicPOs, namespace);
    }

    public <E extends Entity & HasIdentifier> TopicEntity updateTopic(NameIdentifier ident, Function<E, E> updater) throws IOException {
        Integer updateResult;
        NameIdentifierUtil.checkTopic(ident);
        String topicName = ident.name();
        Long schemaId = CommonMetaService.getInstance().getParentEntityIdByNamespace(ident.namespace());
        TopicPO oldTopicPO = this.getTopicPOBySchemaIdAndName(schemaId, topicName);
        TopicEntity oldTopicEntity = POConverters.fromTopicPO(oldTopicPO, ident.namespace());
        TopicEntity newEntity = (TopicEntity)updater.apply(oldTopicEntity);
        Preconditions.checkArgument((boolean)Objects.equals(oldTopicEntity.id(), newEntity.id()), (String)"The updated topic entity id: %s should be same with the topic entity id before: %s", (Object)newEntity.id(), (Object)oldTopicEntity.id());
        try {
            updateResult = SessionUtils.doWithCommitAndFetchResult(TopicMetaMapper.class, mapper -> mapper.updateTopicMeta(POConverters.updateTopicPOWithVersion(oldTopicPO, newEntity), oldTopicPO));
        }
        catch (RuntimeException re) {
            ExceptionUtils.checkSQLException(re, Entity.EntityType.TOPIC, newEntity.nameIdentifier().toString());
            throw re;
        }
        if (updateResult > 0) {
            return newEntity;
        }
        throw new IOException("Failed to update the entity: " + ident);
    }

    private TopicPO getTopicPOBySchemaIdAndName(Long schemaId, String topicName) {
        TopicPO topicPO = SessionUtils.getWithoutCommit(TopicMetaMapper.class, mapper -> mapper.selectTopicMetaBySchemaIdAndName(schemaId, topicName));
        if (topicPO == null) {
            throw new NoSuchEntityException("No such %s entity: %s", new Object[]{Entity.EntityType.TOPIC.name().toLowerCase(), topicName});
        }
        return topicPO;
    }

    public TopicPO getTopicPOById(Long topicId) {
        TopicPO topicPO = SessionUtils.getWithoutCommit(TopicMetaMapper.class, mapper -> mapper.selectTopicMetaById(topicId));
        return topicPO;
    }

    private void fillTopicPOBuilderParentEntityId(TopicPO.Builder builder, Namespace namespace) {
        NamespaceUtil.checkTopic(namespace);
        Long parentEntityId = null;
        block5: for (int level = 0; level < namespace.levels().length; ++level) {
            String name = namespace.level(level);
            switch (level) {
                case 0: {
                    parentEntityId = MetalakeMetaService.getInstance().getMetalakeIdByName(name);
                    builder.withMetalakeId(parentEntityId);
                    continue block5;
                }
                case 1: {
                    parentEntityId = CatalogMetaService.getInstance().getCatalogIdByMetalakeIdAndName(parentEntityId, name);
                    builder.withCatalogId(parentEntityId);
                    continue block5;
                }
                case 2: {
                    parentEntityId = SchemaMetaService.getInstance().getSchemaIdByCatalogIdAndName(parentEntityId, name);
                    builder.withSchemaId(parentEntityId);
                }
            }
        }
    }

    public TopicEntity getTopicByIdentifier(NameIdentifier identifier) {
        NameIdentifierUtil.checkTopic(identifier);
        Long schemaId = CommonMetaService.getInstance().getParentEntityIdByNamespace(identifier.namespace());
        TopicPO topicPO = this.getTopicPOBySchemaIdAndName(schemaId, identifier.name());
        return POConverters.fromTopicPO(topicPO, identifier.namespace());
    }

    public boolean deleteTopic(NameIdentifier identifier) {
        NameIdentifierUtil.checkTopic(identifier);
        String topicName = identifier.name();
        Long schemaId = CommonMetaService.getInstance().getParentEntityIdByNamespace(identifier.namespace());
        Long topicId = this.getTopicIdBySchemaIdAndName(schemaId, topicName);
        SessionUtils.doMultipleWithCommit(() -> SessionUtils.doWithoutCommit(TopicMetaMapper.class, mapper -> mapper.softDeleteTopicMetasByTopicId(topicId)), () -> SessionUtils.doWithoutCommit(OwnerMetaMapper.class, mapper -> mapper.softDeleteOwnerRelByMetadataObjectIdAndType(topicId, MetadataObject.Type.TOPIC.name())));
        return true;
    }

    public int deleteTopicMetasByLegacyTimeline(Long legacyTimeline, int limit) {
        return SessionUtils.doWithCommitAndFetchResult(TopicMetaMapper.class, mapper -> mapper.deleteTopicMetasByLegacyTimeline(legacyTimeline, limit));
    }

    public Long getTopicIdBySchemaIdAndName(Long schemaId, String topicName) {
        Long topicId = SessionUtils.getWithoutCommit(TopicMetaMapper.class, mapper -> mapper.selectTopicIdBySchemaIdAndName(schemaId, topicName));
        if (topicId == null) {
            throw new NoSuchEntityException("No such %s entity: %s", new Object[]{Entity.EntityType.TOPIC.name().toLowerCase(), topicName});
        }
        return topicId;
    }
}

