/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.server.web.rest;

import com.codahale.metrics.annotation.ResponseMetered;
import com.codahale.metrics.annotation.Timed;
import java.util.Arrays;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.gravitino.Metalake;
import org.apache.gravitino.MetalakeChange;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.dto.MetalakeDTO;
import org.apache.gravitino.dto.requests.MetalakeCreateRequest;
import org.apache.gravitino.dto.requests.MetalakeSetRequest;
import org.apache.gravitino.dto.requests.MetalakeUpdateRequest;
import org.apache.gravitino.dto.requests.MetalakeUpdatesRequest;
import org.apache.gravitino.dto.responses.BaseResponse;
import org.apache.gravitino.dto.responses.DropResponse;
import org.apache.gravitino.dto.responses.MetalakeListResponse;
import org.apache.gravitino.dto.responses.MetalakeResponse;
import org.apache.gravitino.dto.util.DTOConverters;
import org.apache.gravitino.lock.LockType;
import org.apache.gravitino.lock.TreeLockUtils;
import org.apache.gravitino.metalake.MetalakeDispatcher;
import org.apache.gravitino.server.web.Utils;
import org.apache.gravitino.server.web.rest.ExceptionHandlers;
import org.apache.gravitino.server.web.rest.OperationType;
import org.apache.gravitino.utils.NameIdentifierUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/metalakes")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class MetalakeOperations {
    private static final Logger LOG = LoggerFactory.getLogger(MetalakeOperations.class);
    private final MetalakeDispatcher metalakeDispatcher;
    @Context
    private HttpServletRequest httpRequest;

    @Inject
    public MetalakeOperations(MetalakeDispatcher dispatcher) {
        this.metalakeDispatcher = dispatcher;
    }

    @GET
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="list-metalake.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="list-metalake", absolute=true)
    public Response listMetalakes() {
        LOG.info("Received list metalakes request.");
        try {
            return Utils.doAs(this.httpRequest, () -> {
                Metalake[] metalakes = (Metalake[])TreeLockUtils.doWithRootTreeLock((LockType)LockType.READ, () -> ((MetalakeDispatcher)this.metalakeDispatcher).listMetalakes());
                MetalakeDTO[] metalakeDTOs = (MetalakeDTO[])Arrays.stream(metalakes).map(DTOConverters::toDTO).toArray(MetalakeDTO[]::new);
                Response response = Utils.ok(new MetalakeListResponse(metalakeDTOs));
                LOG.info("List {} metalakes in Gravitino", (Object)metalakeDTOs.length);
                return response;
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleMetalakeException(OperationType.LIST, Namespace.empty().toString(), e);
        }
    }

    @POST
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="create-metalake.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="create-metalake", absolute=true)
    public Response createMetalake(MetalakeCreateRequest request) {
        LOG.info("Received create metalake request for {}", (Object)request.getName());
        try {
            return Utils.doAs(this.httpRequest, () -> {
                request.validate();
                NameIdentifier ident = NameIdentifierUtil.ofMetalake((String)request.getName());
                Metalake metalake = (Metalake)TreeLockUtils.doWithRootTreeLock((LockType)LockType.WRITE, () -> this.metalakeDispatcher.createMetalake(ident, request.getComment(), request.getProperties()));
                Response response = Utils.ok(new MetalakeResponse(DTOConverters.toDTO((Metalake)metalake)));
                LOG.info("Metalake created: {}", (Object)metalake.name());
                return response;
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleMetalakeException(OperationType.CREATE, request.getName(), e);
        }
    }

    @GET
    @Path(value="{name}")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="load-metalake.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="load-metalake", absolute=true)
    public Response loadMetalake(@PathParam(value="name") String metalakeName) {
        LOG.info("Received load metalake request for metalake: {}", (Object)metalakeName);
        try {
            return Utils.doAs(this.httpRequest, () -> {
                NameIdentifier identifier = NameIdentifierUtil.ofMetalake((String)metalakeName);
                Metalake metalake = (Metalake)TreeLockUtils.doWithTreeLock((NameIdentifier)identifier, (LockType)LockType.READ, () -> this.metalakeDispatcher.loadMetalake(identifier));
                Response response = Utils.ok(new MetalakeResponse(DTOConverters.toDTO((Metalake)metalake)));
                LOG.info("Metalake loaded: {}", (Object)metalake.name());
                return response;
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleMetalakeException(OperationType.LOAD, metalakeName, e);
        }
    }

    @PATCH
    @Path(value="{name}")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="set-metalake.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="set-metalake", absolute=true)
    public Response setMetalake(@PathParam(value="name") String metalakeName, MetalakeSetRequest request) {
        LOG.info("Received set request for metalake: {}", (Object)metalakeName);
        try {
            return Utils.doAs(this.httpRequest, () -> {
                NameIdentifier identifier = NameIdentifierUtil.ofMetalake((String)metalakeName);
                TreeLockUtils.doWithTreeLock((NameIdentifier)identifier, (LockType)LockType.WRITE, () -> {
                    if (request.isInUse()) {
                        this.metalakeDispatcher.enableMetalake(identifier);
                    } else {
                        this.metalakeDispatcher.disableMetalake(identifier);
                    }
                    return null;
                });
                Response response = Utils.ok(new BaseResponse());
                LOG.info("Successfully {} metalake: {}", (Object)(request.isInUse() ? "enable" : "disable"), (Object)metalakeName);
                return response;
            });
        }
        catch (Exception e) {
            LOG.info("Failed to {} metalake: {}", (Object)(request.isInUse() ? "enable" : "disable"), (Object)metalakeName);
            return ExceptionHandlers.handleMetalakeException(OperationType.LOAD, metalakeName, e);
        }
    }

    @PUT
    @Path(value="{name}")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="alter-metalake.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="alter-metalake", absolute=true)
    public Response alterMetalake(@PathParam(value="name") String metalakeName, MetalakeUpdatesRequest updatesRequest) {
        LOG.info("Received alter metalake request for metalake: {}", (Object)metalakeName);
        try {
            return Utils.doAs(this.httpRequest, () -> {
                updatesRequest.validate();
                NameIdentifier identifier = NameIdentifierUtil.ofMetalake((String)metalakeName);
                MetalakeChange[] changes = (MetalakeChange[])updatesRequest.getUpdates().stream().map(MetalakeUpdateRequest::metalakeChange).toArray(MetalakeChange[]::new);
                Metalake updatedMetalake = (Metalake)TreeLockUtils.doWithRootTreeLock((LockType)LockType.WRITE, () -> this.metalakeDispatcher.alterMetalake(identifier, changes));
                Response response = Utils.ok(new MetalakeResponse(DTOConverters.toDTO((Metalake)updatedMetalake)));
                LOG.info("Metalake altered: {}", (Object)updatedMetalake.name());
                return response;
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleMetalakeException(OperationType.ALTER, metalakeName, e);
        }
    }

    @DELETE
    @Path(value="{name}")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="drop-metalake.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="drop-metalake", absolute=true)
    public Response dropMetalake(@PathParam(value="name") String metalakeName, @DefaultValue(value="false") @QueryParam(value="force") boolean force) {
        LOG.info("Received drop metalake request for metalake: {}", (Object)metalakeName);
        try {
            return Utils.doAs(this.httpRequest, () -> {
                NameIdentifier identifier = NameIdentifierUtil.ofMetalake((String)metalakeName);
                boolean dropped = (Boolean)TreeLockUtils.doWithRootTreeLock((LockType)LockType.WRITE, () -> this.metalakeDispatcher.dropMetalake(identifier, force));
                if (!dropped) {
                    LOG.warn("Failed to drop metalake by name {}", (Object)metalakeName);
                }
                Response response = Utils.ok(new DropResponse(dropped));
                LOG.info("Metalake dropped: {}", (Object)metalakeName);
                return response;
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleMetalakeException(OperationType.DROP, metalakeName, e);
        }
    }
}

