/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.server.web.rest;

import com.codahale.metrics.annotation.ResponseMetered;
import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.gravitino.GravitinoEnv;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.MetadataObjects;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.authorization.AccessControlDispatcher;
import org.apache.gravitino.authorization.AuthorizationUtils;
import org.apache.gravitino.authorization.Privilege;
import org.apache.gravitino.authorization.Role;
import org.apache.gravitino.authorization.SecurableObjects;
import org.apache.gravitino.dto.authorization.PrivilegeDTO;
import org.apache.gravitino.dto.authorization.SecurableObjectDTO;
import org.apache.gravitino.dto.requests.RoleCreateRequest;
import org.apache.gravitino.dto.responses.DeleteResponse;
import org.apache.gravitino.dto.responses.NameListResponse;
import org.apache.gravitino.dto.responses.RoleResponse;
import org.apache.gravitino.dto.util.DTOConverters;
import org.apache.gravitino.exceptions.IllegalMetadataObjectException;
import org.apache.gravitino.exceptions.NoSuchMetadataObjectException;
import org.apache.gravitino.lock.LockType;
import org.apache.gravitino.lock.TreeLockUtils;
import org.apache.gravitino.server.authorization.NameBindings;
import org.apache.gravitino.server.web.Utils;
import org.apache.gravitino.server.web.rest.ExceptionHandlers;
import org.apache.gravitino.server.web.rest.OperationType;
import org.apache.gravitino.utils.MetadataObjectUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NameBindings.AccessControlInterfaces
@Path(value="/metalakes/{metalake}/roles")
public class RoleOperations {
    private static final Logger LOG = LoggerFactory.getLogger(RoleOperations.class);
    private final AccessControlDispatcher accessControlManager = GravitinoEnv.getInstance().accessControlDispatcher();
    @Context
    private HttpServletRequest httpRequest;

    @GET
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="list-role.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="list-role", absolute=true)
    public Response listRoles(@PathParam(value="metalake") String metalake) {
        try {
            return Utils.doAs(this.httpRequest, () -> (Response)TreeLockUtils.doWithTreeLock((NameIdentifier)NameIdentifier.of((String[])new String[]{metalake}), (LockType)LockType.READ, () -> {
                String[] names = this.accessControlManager.listRoleNames(metalake);
                return Utils.ok(new NameListResponse(names));
            }));
        }
        catch (Exception e) {
            return ExceptionHandlers.handleRoleException(OperationType.LIST, "", metalake, e);
        }
    }

    @GET
    @Path(value="{role}")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="get-role.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="get-role", absolute=true)
    public Response getRole(@PathParam(value="metalake") String metalake, @PathParam(value="role") String role) {
        try {
            return Utils.doAs(this.httpRequest, () -> (Response)TreeLockUtils.doWithTreeLock((NameIdentifier)AuthorizationUtils.ofRole((String)metalake, (String)role), (LockType)LockType.READ, () -> Utils.ok(new RoleResponse(DTOConverters.toDTO((Role)this.accessControlManager.getRole(metalake, role))))));
        }
        catch (Exception e) {
            return ExceptionHandlers.handleRoleException(OperationType.GET, role, metalake, e);
        }
    }

    @POST
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="create-role.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="create-role", absolute=true)
    public Response createRole(@PathParam(value="metalake") String metalake, RoleCreateRequest request) {
        try {
            return Utils.doAs(this.httpRequest, () -> {
                HashSet metadataObjects = Sets.newHashSet();
                for (SecurableObjectDTO object : request.getSecurableObjects()) {
                    MetadataObject metadataObject = MetadataObjects.parse((String)object.getFullName(), (MetadataObject.Type)object.type());
                    if (metadataObjects.contains(metadataObject)) {
                        throw new IllegalArgumentException(String.format("Doesn't support specifying duplicated securable objects %s type %s", object.fullName(), object.type()));
                    }
                    metadataObjects.add(metadataObject);
                    HashSet privileges = Sets.newHashSet((Iterable)object.privileges());
                    AuthorizationUtils.checkDuplicatedNamePrivilege((Collection)privileges);
                    for (Privilege privilege : object.privileges()) {
                        AuthorizationUtils.checkPrivilege((PrivilegeDTO)((PrivilegeDTO)privilege), (MetadataObject)object, (String)metalake);
                    }
                    try {
                        MetadataObjectUtil.checkMetadataObject((String)metalake, (MetadataObject)object);
                    }
                    catch (NoSuchMetadataObjectException nsm) {
                        throw new IllegalMetadataObjectException((Throwable)nsm);
                    }
                }
                List securableObjects = Arrays.stream(request.getSecurableObjects()).map(securableObjectDTO -> SecurableObjects.parse((String)securableObjectDTO.fullName(), (MetadataObject.Type)securableObjectDTO.type(), securableObjectDTO.privileges().stream().map(privilege -> DTOConverters.fromPrivilegeDTO((PrivilegeDTO)((PrivilegeDTO)privilege))).collect(Collectors.toList()))).collect(Collectors.toList());
                return (Response)TreeLockUtils.doWithTreeLock((NameIdentifier)NameIdentifier.of((String[])AuthorizationUtils.ofRoleNamespace((String)metalake).levels()), (LockType)LockType.WRITE, () -> Utils.ok(new RoleResponse(DTOConverters.toDTO((Role)this.accessControlManager.createRole(metalake, request.getName(), request.getProperties(), securableObjects)))));
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleRoleException(OperationType.CREATE, request.getName(), metalake, e);
        }
    }

    @DELETE
    @Path(value="{role}")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="delete-role.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="delete-role", absolute=true)
    public Response deleteRole(@PathParam(value="metalake") String metalake, @PathParam(value="role") String role) {
        try {
            return Utils.doAs(this.httpRequest, () -> {
                boolean deleted = (Boolean)TreeLockUtils.doWithTreeLock((NameIdentifier)NameIdentifier.of((String[])AuthorizationUtils.ofRoleNamespace((String)metalake).levels()), (LockType)LockType.WRITE, () -> this.accessControlManager.deleteRole(metalake, role));
                if (!deleted) {
                    LOG.warn("Failed to delete role {} under metalake {}", (Object)role, (Object)metalake);
                }
                return Utils.ok(new DeleteResponse(deleted));
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleRoleException(OperationType.DELETE, role, metalake, e);
        }
    }
}

