/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.server.web.rest;

import com.codahale.metrics.annotation.ResponseMetered;
import com.codahale.metrics.annotation.Timed;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.gravitino.GravitinoEnv;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.authorization.AccessControlDispatcher;
import org.apache.gravitino.authorization.AuthorizationUtils;
import org.apache.gravitino.authorization.User;
import org.apache.gravitino.dto.requests.UserAddRequest;
import org.apache.gravitino.dto.responses.NameListResponse;
import org.apache.gravitino.dto.responses.RemoveResponse;
import org.apache.gravitino.dto.responses.UserListResponse;
import org.apache.gravitino.dto.responses.UserResponse;
import org.apache.gravitino.dto.util.DTOConverters;
import org.apache.gravitino.lock.LockType;
import org.apache.gravitino.lock.TreeLockUtils;
import org.apache.gravitino.server.authorization.NameBindings;
import org.apache.gravitino.server.web.Utils;
import org.apache.gravitino.server.web.rest.ExceptionHandlers;
import org.apache.gravitino.server.web.rest.OperationType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NameBindings.AccessControlInterfaces
@Path(value="/metalakes/{metalake}/users")
public class UserOperations {
    private static final Logger LOG = LoggerFactory.getLogger(UserOperations.class);
    private final AccessControlDispatcher accessControlManager = GravitinoEnv.getInstance().accessControlDispatcher();
    @Context
    private HttpServletRequest httpRequest;

    @GET
    @Path(value="{user}")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="get-user.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="get-user", absolute=true)
    public Response getUser(@PathParam(value="metalake") String metalake, @PathParam(value="user") String user) {
        try {
            return Utils.doAs(this.httpRequest, () -> (Response)TreeLockUtils.doWithTreeLock((NameIdentifier)AuthorizationUtils.ofGroup((String)metalake, (String)user), (LockType)LockType.READ, () -> Utils.ok(new UserResponse(DTOConverters.toDTO((User)this.accessControlManager.getUser(metalake, user))))));
        }
        catch (Exception e) {
            return ExceptionHandlers.handleUserException(OperationType.GET, user, metalake, e);
        }
    }

    @GET
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="list-user.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="list-user", absolute=true)
    public Response listUsers(@PathParam(value="metalake") String metalake, @QueryParam(value="details") @DefaultValue(value="false") boolean verbose) {
        try {
            return Utils.doAs(this.httpRequest, () -> (Response)TreeLockUtils.doWithTreeLock((NameIdentifier)NameIdentifier.of((String[])AuthorizationUtils.ofUserNamespace((String)metalake).levels()), (LockType)LockType.READ, () -> {
                if (verbose) {
                    return Utils.ok(new UserListResponse(DTOConverters.toDTOs((User[])this.accessControlManager.listUsers(metalake))));
                }
                return Utils.ok(new NameListResponse(this.accessControlManager.listUserNames(metalake)));
            }));
        }
        catch (Exception e) {
            return ExceptionHandlers.handleUserException(OperationType.LIST, "", metalake, e);
        }
    }

    @POST
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="add-user.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="add-user", absolute=true)
    public Response addUser(@PathParam(value="metalake") String metalake, UserAddRequest request) {
        try {
            return Utils.doAs(this.httpRequest, () -> (Response)TreeLockUtils.doWithTreeLock((NameIdentifier)NameIdentifier.of((String[])AuthorizationUtils.ofGroupNamespace((String)metalake).levels()), (LockType)LockType.WRITE, () -> Utils.ok(new UserResponse(DTOConverters.toDTO((User)this.accessControlManager.addUser(metalake, request.getName()))))));
        }
        catch (Exception e) {
            return ExceptionHandlers.handleUserException(OperationType.ADD, request.getName(), metalake, e);
        }
    }

    @DELETE
    @Path(value="{user}")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="remove-user.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="remove-user", absolute=true)
    public Response removeUser(@PathParam(value="metalake") String metalake, @PathParam(value="user") String user) {
        try {
            return Utils.doAs(this.httpRequest, () -> {
                boolean removed = (Boolean)TreeLockUtils.doWithTreeLock((NameIdentifier)NameIdentifier.of((String[])AuthorizationUtils.ofGroupNamespace((String)metalake).levels()), (LockType)LockType.WRITE, () -> this.accessControlManager.removeUser(metalake, user));
                if (!removed) {
                    LOG.warn("Failed to remove user {} under metalake {}", (Object)user, (Object)metalake);
                }
                return Utils.ok(new RemoveResponse(removed));
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleUserException(OperationType.REMOVE, user, metalake, e);
        }
    }
}

