/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.encryption;

import org.apache.iceberg.encryption.EncryptedFiles;
import org.apache.iceberg.encryption.EncryptedInputFile;
import org.apache.iceberg.encryption.EncryptedOutputFile;
import org.apache.iceberg.encryption.EncryptionKeyMetadata;
import org.apache.iceberg.encryption.EncryptionManager;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlaintextEncryptionManager
implements EncryptionManager {
    private static final EncryptionManager INSTANCE = new PlaintextEncryptionManager();
    private static final Logger LOG = LoggerFactory.getLogger(PlaintextEncryptionManager.class);

    @Deprecated
    public PlaintextEncryptionManager() {
    }

    public static EncryptionManager instance() {
        return INSTANCE;
    }

    public InputFile decrypt(EncryptedInputFile encrypted) {
        if (encrypted.keyMetadata().buffer() != null) {
            LOG.warn("File encryption key metadata is present, but no encryption has been configured.");
        }
        return encrypted.encryptedInputFile();
    }

    public EncryptedOutputFile encrypt(OutputFile rawOutput) {
        return EncryptedFiles.encryptedOutput(rawOutput, EncryptionKeyMetadata.empty());
    }
}

