/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.listener;

import java.util.Map;
import org.apache.gravitino.Metalake;
import org.apache.gravitino.MetalakeChange;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.exceptions.MetalakeAlreadyExistsException;
import org.apache.gravitino.exceptions.MetalakeInUseException;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;
import org.apache.gravitino.exceptions.NonEmptyEntityException;
import org.apache.gravitino.listener.EventBus;
import org.apache.gravitino.listener.api.event.AlterMetalakeEvent;
import org.apache.gravitino.listener.api.event.AlterMetalakeFailureEvent;
import org.apache.gravitino.listener.api.event.CreateMetalakeEvent;
import org.apache.gravitino.listener.api.event.CreateMetalakeFailureEvent;
import org.apache.gravitino.listener.api.event.DropMetalakeEvent;
import org.apache.gravitino.listener.api.event.DropMetalakeFailureEvent;
import org.apache.gravitino.listener.api.event.ListMetalakeEvent;
import org.apache.gravitino.listener.api.event.ListMetalakeFailureEvent;
import org.apache.gravitino.listener.api.event.LoadMetalakeEvent;
import org.apache.gravitino.listener.api.event.LoadMetalakeFailureEvent;
import org.apache.gravitino.listener.api.info.MetalakeInfo;
import org.apache.gravitino.metalake.MetalakeDispatcher;
import org.apache.gravitino.utils.PrincipalUtils;

public class MetalakeEventDispatcher
implements MetalakeDispatcher {
    private final EventBus eventBus;
    private final MetalakeDispatcher dispatcher;

    public MetalakeEventDispatcher(EventBus eventBus, MetalakeDispatcher dispatcher) {
        this.eventBus = eventBus;
        this.dispatcher = dispatcher;
    }

    @Override
    public Metalake[] listMetalakes() {
        try {
            Metalake[] metalakes = this.dispatcher.listMetalakes();
            this.eventBus.dispatchEvent(new ListMetalakeEvent(PrincipalUtils.getCurrentUserName()));
            return metalakes;
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent(new ListMetalakeFailureEvent(PrincipalUtils.getCurrentUserName(), e));
            throw e;
        }
    }

    @Override
    public Metalake loadMetalake(NameIdentifier ident) throws NoSuchMetalakeException {
        try {
            Metalake metalake = this.dispatcher.loadMetalake(ident);
            this.eventBus.dispatchEvent(new LoadMetalakeEvent(PrincipalUtils.getCurrentUserName(), ident, new MetalakeInfo(metalake)));
            return metalake;
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent(new LoadMetalakeFailureEvent(PrincipalUtils.getCurrentUserName(), ident, e));
            throw e;
        }
    }

    @Override
    public boolean metalakeExists(NameIdentifier ident) {
        return this.dispatcher.metalakeExists(ident);
    }

    @Override
    public Metalake createMetalake(NameIdentifier ident, String comment, Map<String, String> properties) throws MetalakeAlreadyExistsException {
        try {
            Metalake metalake = this.dispatcher.createMetalake(ident, comment, properties);
            this.eventBus.dispatchEvent(new CreateMetalakeEvent(PrincipalUtils.getCurrentUserName(), ident, new MetalakeInfo(metalake)));
            return metalake;
        }
        catch (Exception e) {
            MetalakeInfo metalakeInfo = new MetalakeInfo(ident.name(), comment, properties, null);
            this.eventBus.dispatchEvent(new CreateMetalakeFailureEvent(PrincipalUtils.getCurrentUserName(), ident, e, metalakeInfo));
            throw e;
        }
    }

    @Override
    public Metalake alterMetalake(NameIdentifier ident, MetalakeChange ... changes) throws NoSuchMetalakeException, IllegalArgumentException {
        try {
            Metalake metalake = this.dispatcher.alterMetalake(ident, changes);
            this.eventBus.dispatchEvent(new AlterMetalakeEvent(PrincipalUtils.getCurrentUserName(), ident, changes, new MetalakeInfo(metalake)));
            return metalake;
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent(new AlterMetalakeFailureEvent(PrincipalUtils.getCurrentUserName(), ident, e, changes));
            throw e;
        }
    }

    @Override
    public boolean dropMetalake(NameIdentifier ident, boolean force) throws NonEmptyEntityException, MetalakeInUseException {
        try {
            boolean isExists = this.dispatcher.dropMetalake(ident, force);
            this.eventBus.dispatchEvent(new DropMetalakeEvent(PrincipalUtils.getCurrentUserName(), ident, isExists));
            return isExists;
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent(new DropMetalakeFailureEvent(PrincipalUtils.getCurrentUserName(), ident, e));
            throw e;
        }
    }

    @Override
    public void enableMetalake(NameIdentifier ident) throws NoSuchMetalakeException {
        this.dispatcher.enableMetalake(ident);
    }

    @Override
    public void disableMetalake(NameIdentifier ident) throws NoSuchMetalakeException {
        this.dispatcher.disableMetalake(ident);
    }
}

