/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.client;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.Catalog;
import org.apache.gravitino.CatalogChange;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.MetadataObjects;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.SupportsCatalogs;
import org.apache.gravitino.authorization.Group;
import org.apache.gravitino.authorization.Owner;
import org.apache.gravitino.authorization.Privilege;
import org.apache.gravitino.authorization.Role;
import org.apache.gravitino.authorization.SecurableObject;
import org.apache.gravitino.authorization.SupportsRoles;
import org.apache.gravitino.authorization.User;
import org.apache.gravitino.client.DTOConverters;
import org.apache.gravitino.client.ErrorHandlers;
import org.apache.gravitino.client.GenericTag;
import org.apache.gravitino.client.MetadataObjectRoleOperations;
import org.apache.gravitino.client.RESTClient;
import org.apache.gravitino.dto.AuditDTO;
import org.apache.gravitino.dto.MetalakeDTO;
import org.apache.gravitino.dto.authorization.SecurableObjectDTO;
import org.apache.gravitino.dto.requests.CatalogCreateRequest;
import org.apache.gravitino.dto.requests.CatalogSetRequest;
import org.apache.gravitino.dto.requests.CatalogUpdatesRequest;
import org.apache.gravitino.dto.requests.GroupAddRequest;
import org.apache.gravitino.dto.requests.OwnerSetRequest;
import org.apache.gravitino.dto.requests.PrivilegeGrantRequest;
import org.apache.gravitino.dto.requests.PrivilegeRevokeRequest;
import org.apache.gravitino.dto.requests.RoleCreateRequest;
import org.apache.gravitino.dto.requests.RoleGrantRequest;
import org.apache.gravitino.dto.requests.RoleRevokeRequest;
import org.apache.gravitino.dto.requests.TagCreateRequest;
import org.apache.gravitino.dto.requests.TagUpdatesRequest;
import org.apache.gravitino.dto.requests.UserAddRequest;
import org.apache.gravitino.dto.responses.CatalogListResponse;
import org.apache.gravitino.dto.responses.CatalogResponse;
import org.apache.gravitino.dto.responses.DeleteResponse;
import org.apache.gravitino.dto.responses.DropResponse;
import org.apache.gravitino.dto.responses.EntityListResponse;
import org.apache.gravitino.dto.responses.ErrorResponse;
import org.apache.gravitino.dto.responses.GroupListResponse;
import org.apache.gravitino.dto.responses.GroupResponse;
import org.apache.gravitino.dto.responses.NameListResponse;
import org.apache.gravitino.dto.responses.OwnerResponse;
import org.apache.gravitino.dto.responses.RemoveResponse;
import org.apache.gravitino.dto.responses.RoleResponse;
import org.apache.gravitino.dto.responses.SetResponse;
import org.apache.gravitino.dto.responses.TagListResponse;
import org.apache.gravitino.dto.responses.TagResponse;
import org.apache.gravitino.dto.responses.UserListResponse;
import org.apache.gravitino.dto.responses.UserResponse;
import org.apache.gravitino.dto.tag.TagDTO;
import org.apache.gravitino.exceptions.CatalogAlreadyExistsException;
import org.apache.gravitino.exceptions.CatalogInUseException;
import org.apache.gravitino.exceptions.GroupAlreadyExistsException;
import org.apache.gravitino.exceptions.IllegalMetadataObjectException;
import org.apache.gravitino.exceptions.IllegalPrivilegeException;
import org.apache.gravitino.exceptions.IllegalRoleException;
import org.apache.gravitino.exceptions.NoSuchCatalogException;
import org.apache.gravitino.exceptions.NoSuchGroupException;
import org.apache.gravitino.exceptions.NoSuchMetadataObjectException;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;
import org.apache.gravitino.exceptions.NoSuchRoleException;
import org.apache.gravitino.exceptions.NoSuchTagException;
import org.apache.gravitino.exceptions.NoSuchUserException;
import org.apache.gravitino.exceptions.NonEmptyEntityException;
import org.apache.gravitino.exceptions.NotFoundException;
import org.apache.gravitino.exceptions.RoleAlreadyExistsException;
import org.apache.gravitino.exceptions.TagAlreadyExistsException;
import org.apache.gravitino.exceptions.UserAlreadyExistsException;
import org.apache.gravitino.rest.RESTRequest;
import org.apache.gravitino.rest.RESTUtils;
import org.apache.gravitino.tag.Tag;
import org.apache.gravitino.tag.TagChange;
import org.apache.gravitino.tag.TagOperations;

public class GravitinoMetalake
extends MetalakeDTO
implements SupportsCatalogs,
TagOperations,
SupportsRoles {
    private static final String API_METALAKES_CATALOGS_PATH = "api/metalakes/%s/catalogs/%s";
    private static final String API_PERMISSION_PATH = "api/metalakes/%s/permissions/%s";
    private static final String API_METALAKES_USERS_PATH = "api/metalakes/%s/users/%s";
    private static final String API_METALAKES_GROUPS_PATH = "api/metalakes/%s/groups/%s";
    private static final String API_METALAKES_ROLES_PATH = "api/metalakes/%s/roles/%s";
    private static final String API_METALAKES_OWNERS_PATH = "api/metalakes/%s/owners/%s";
    private static final String API_METALAKES_TAGS_PATH = "api/metalakes/%s/tags";
    private static final String BLANK_PLACEHOLDER = "";
    private final RESTClient restClient;
    private final MetadataObjectRoleOperations metadataObjectRoleOperations;

    GravitinoMetalake(String name, String comment, Map<String, String> properties, AuditDTO auditDTO, RESTClient restClient) {
        super(name, comment, properties, auditDTO);
        this.restClient = restClient;
        this.metadataObjectRoleOperations = new MetadataObjectRoleOperations(name, MetadataObjects.of(null, (String)name, (MetadataObject.Type)MetadataObject.Type.METALAKE), restClient);
    }

    public String[] listCatalogs() throws NoSuchMetalakeException {
        EntityListResponse resp = this.restClient.get(String.format("api/metalakes/%s/catalogs", this.name()), EntityListResponse.class, Collections.emptyMap(), ErrorHandlers.catalogErrorHandler());
        resp.validate();
        return (String[])Arrays.stream(resp.identifiers()).map(NameIdentifier::name).toArray(String[]::new);
    }

    public Catalog[] listCatalogsInfo() throws NoSuchMetalakeException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("details", "true");
        CatalogListResponse resp = this.restClient.get(String.format("api/metalakes/%s/catalogs", this.name()), params, CatalogListResponse.class, Collections.emptyMap(), ErrorHandlers.catalogErrorHandler());
        return (Catalog[])Arrays.stream(resp.getCatalogs()).map(c -> DTOConverters.toCatalog(this.name(), c, this.restClient)).toArray(Catalog[]::new);
    }

    public Catalog loadCatalog(String catalogName) throws NoSuchCatalogException {
        CatalogResponse resp = this.restClient.get(String.format(API_METALAKES_CATALOGS_PATH, this.name(), catalogName), CatalogResponse.class, Collections.emptyMap(), ErrorHandlers.catalogErrorHandler());
        resp.validate();
        return DTOConverters.toCatalog(this.name(), resp.getCatalog(), this.restClient);
    }

    public Catalog createCatalog(String catalogName, Catalog.Type type, String provider, String comment, Map<String, String> properties) throws NoSuchMetalakeException, CatalogAlreadyExistsException {
        CatalogCreateRequest req = new CatalogCreateRequest(catalogName, type, provider, comment, properties);
        req.validate();
        CatalogResponse resp = this.restClient.post(String.format("api/metalakes/%s/catalogs", this.name()), (RESTRequest)req, CatalogResponse.class, Collections.emptyMap(), ErrorHandlers.catalogErrorHandler());
        resp.validate();
        return DTOConverters.toCatalog(this.name(), resp.getCatalog(), this.restClient);
    }

    public Catalog alterCatalog(String catalogName, CatalogChange ... changes) throws NoSuchCatalogException, IllegalArgumentException {
        List reqs = Arrays.stream(changes).map(DTOConverters::toCatalogUpdateRequest).collect(Collectors.toList());
        CatalogUpdatesRequest updatesRequest = new CatalogUpdatesRequest(reqs);
        updatesRequest.validate();
        CatalogResponse resp = this.restClient.put(String.format(API_METALAKES_CATALOGS_PATH, this.name(), catalogName), (RESTRequest)updatesRequest, CatalogResponse.class, Collections.emptyMap(), ErrorHandlers.catalogErrorHandler());
        resp.validate();
        return DTOConverters.toCatalog(this.name(), resp.getCatalog(), this.restClient);
    }

    public boolean dropCatalog(String catalogName, boolean force) throws NonEmptyEntityException, CatalogInUseException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("force", String.valueOf(force));
        DropResponse resp = this.restClient.delete(String.format(API_METALAKES_CATALOGS_PATH, this.name(), catalogName), params, DropResponse.class, Collections.emptyMap(), ErrorHandlers.catalogErrorHandler());
        resp.validate();
        return resp.dropped();
    }

    public void enableCatalog(String catalogName) throws NoSuchCatalogException {
        CatalogSetRequest req = new CatalogSetRequest(true);
        ErrorResponse resp = this.restClient.patch(String.format(API_METALAKES_CATALOGS_PATH, this.name(), catalogName), (RESTRequest)req, ErrorResponse.class, Collections.emptyMap(), ErrorHandlers.catalogErrorHandler());
        if (resp.getCode() == 0) {
            return;
        }
        ErrorHandlers.catalogErrorHandler().accept(resp);
    }

    public void disableCatalog(String catalogName) throws NoSuchCatalogException {
        CatalogSetRequest req = new CatalogSetRequest(false);
        ErrorResponse resp = this.restClient.patch(String.format(API_METALAKES_CATALOGS_PATH, this.name(), catalogName), (RESTRequest)req, ErrorResponse.class, Collections.emptyMap(), ErrorHandlers.catalogErrorHandler());
        if (resp.getCode() == 0) {
            return;
        }
        ErrorHandlers.catalogErrorHandler().accept(resp);
    }

    public void testConnection(String catalogName, Catalog.Type type, String provider, String comment, Map<String, String> properties) throws Exception {
        CatalogCreateRequest req = new CatalogCreateRequest(catalogName, type, provider, comment, properties);
        req.validate();
        ErrorResponse resp = this.restClient.post(String.format("api/metalakes/%s/catalogs/testConnection", this.name()), (RESTRequest)req, ErrorResponse.class, Collections.emptyMap(), ErrorHandlers.catalogErrorHandler());
        if (resp.getCode() == 0) {
            return;
        }
        ErrorHandlers.catalogErrorHandler().accept(resp);
    }

    public SupportsRoles supportsRoles() {
        return this;
    }

    public String[] listTags() throws NoSuchMetalakeException {
        NameListResponse resp = this.restClient.get(String.format(API_METALAKES_TAGS_PATH, this.name()), NameListResponse.class, Collections.emptyMap(), ErrorHandlers.tagErrorHandler());
        resp.validate();
        return resp.getNames();
    }

    public Tag[] listTagsInfo() throws NoSuchMetalakeException {
        ImmutableMap params = ImmutableMap.of((Object)"details", (Object)"true");
        TagListResponse resp = this.restClient.get(String.format(API_METALAKES_TAGS_PATH, this.name()), (Map<String, String>)params, TagListResponse.class, Collections.emptyMap(), ErrorHandlers.tagErrorHandler());
        resp.validate();
        return (Tag[])Arrays.stream(resp.getTags()).map(t -> new GenericTag((TagDTO)t, this.restClient, this.name())).toArray(Tag[]::new);
    }

    public Tag getTag(String name) throws NoSuchTagException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)name), (Object)"tag name must not be null or empty");
        TagResponse resp = this.restClient.get(String.format(API_METALAKES_TAGS_PATH, this.name()) + "/" + name, TagResponse.class, Collections.emptyMap(), ErrorHandlers.tagErrorHandler());
        resp.validate();
        return new GenericTag(resp.getTag(), this.restClient, this.name());
    }

    public Tag createTag(String name, String comment, Map<String, String> properties) throws TagAlreadyExistsException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)name), (Object)"tag name must not be null or empty");
        TagCreateRequest req = new TagCreateRequest(name, comment, properties);
        req.validate();
        TagResponse resp = this.restClient.post(String.format(API_METALAKES_TAGS_PATH, this.name()), (RESTRequest)req, TagResponse.class, Collections.emptyMap(), ErrorHandlers.tagErrorHandler());
        resp.validate();
        return new GenericTag(resp.getTag(), this.restClient, this.name());
    }

    public Tag alterTag(String name, TagChange ... changes) throws NoSuchTagException, IllegalArgumentException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)name), (Object)"tag name must not be null or empty");
        List updates = Arrays.stream(changes).map(DTOConverters::toTagUpdateRequest).collect(Collectors.toList());
        TagUpdatesRequest req = new TagUpdatesRequest(updates);
        req.validate();
        TagResponse resp = this.restClient.put(String.format(API_METALAKES_TAGS_PATH, this.name()) + "/" + name, (RESTRequest)req, TagResponse.class, Collections.emptyMap(), ErrorHandlers.tagErrorHandler());
        resp.validate();
        return new GenericTag(resp.getTag(), this.restClient, this.name());
    }

    public boolean deleteTag(String name) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)name), (Object)"tag name must not be null or empty");
        DropResponse resp = this.restClient.delete(String.format(API_METALAKES_TAGS_PATH, this.name()) + "/" + name, DropResponse.class, Collections.emptyMap(), ErrorHandlers.tagErrorHandler());
        resp.validate();
        return resp.dropped();
    }

    public User addUser(String user) throws UserAlreadyExistsException, NoSuchMetalakeException {
        UserAddRequest req = new UserAddRequest(user);
        req.validate();
        UserResponse resp = this.restClient.post(String.format(API_METALAKES_USERS_PATH, this.name(), BLANK_PLACEHOLDER), (RESTRequest)req, UserResponse.class, Collections.emptyMap(), ErrorHandlers.userErrorHandler());
        resp.validate();
        return resp.getUser();
    }

    public boolean removeUser(String user) throws NoSuchMetalakeException {
        RemoveResponse resp = this.restClient.delete(String.format(API_METALAKES_USERS_PATH, this.name(), RESTUtils.encodeString((String)user)), RemoveResponse.class, Collections.emptyMap(), ErrorHandlers.userErrorHandler());
        resp.validate();
        return resp.removed();
    }

    public User getUser(String user) throws NoSuchUserException, NoSuchMetalakeException {
        UserResponse resp = this.restClient.get(String.format(API_METALAKES_USERS_PATH, this.name(), RESTUtils.encodeString((String)user)), UserResponse.class, Collections.emptyMap(), ErrorHandlers.userErrorHandler());
        resp.validate();
        return resp.getUser();
    }

    public User[] listUsers() throws NoSuchMetalakeException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("details", "true");
        UserListResponse resp = this.restClient.get(String.format(API_METALAKES_USERS_PATH, this.name(), BLANK_PLACEHOLDER), params, UserListResponse.class, Collections.emptyMap(), ErrorHandlers.userErrorHandler());
        resp.validate();
        return resp.getUsers();
    }

    public String[] listUserNames() throws NoSuchMetalakeException {
        NameListResponse resp = this.restClient.get(String.format(API_METALAKES_USERS_PATH, this.name(), BLANK_PLACEHOLDER), NameListResponse.class, Collections.emptyMap(), ErrorHandlers.userErrorHandler());
        resp.validate();
        return resp.getNames();
    }

    public Group addGroup(String group) throws GroupAlreadyExistsException, NoSuchMetalakeException {
        GroupAddRequest req = new GroupAddRequest(group);
        req.validate();
        GroupResponse resp = this.restClient.post(String.format(API_METALAKES_GROUPS_PATH, this.name(), BLANK_PLACEHOLDER), (RESTRequest)req, GroupResponse.class, Collections.emptyMap(), ErrorHandlers.groupErrorHandler());
        resp.validate();
        return resp.getGroup();
    }

    public boolean removeGroup(String group) throws NoSuchMetalakeException {
        RemoveResponse resp = this.restClient.delete(String.format(API_METALAKES_GROUPS_PATH, this.name(), RESTUtils.encodeString((String)group)), RemoveResponse.class, Collections.emptyMap(), ErrorHandlers.groupErrorHandler());
        resp.validate();
        return resp.removed();
    }

    public Group getGroup(String group) throws NoSuchGroupException, NoSuchMetalakeException {
        GroupResponse resp = this.restClient.get(String.format(API_METALAKES_GROUPS_PATH, this.name(), RESTUtils.encodeString((String)group)), GroupResponse.class, Collections.emptyMap(), ErrorHandlers.groupErrorHandler());
        resp.validate();
        return resp.getGroup();
    }

    public Group[] listGroups() throws NoSuchMetalakeException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("details", "true");
        GroupListResponse resp = this.restClient.get(String.format(API_METALAKES_GROUPS_PATH, this.name(), BLANK_PLACEHOLDER), params, GroupListResponse.class, Collections.emptyMap(), ErrorHandlers.groupErrorHandler());
        resp.validate();
        return resp.getGroups();
    }

    public String[] listGroupNames() throws NoSuchMetalakeException {
        NameListResponse resp = this.restClient.get(String.format(API_METALAKES_GROUPS_PATH, this.name(), BLANK_PLACEHOLDER), NameListResponse.class, Collections.emptyMap(), ErrorHandlers.groupErrorHandler());
        resp.validate();
        return resp.getNames();
    }

    public Role getRole(String role) throws NoSuchRoleException, NoSuchMetalakeException {
        RoleResponse resp = this.restClient.get(String.format(API_METALAKES_ROLES_PATH, this.name(), RESTUtils.encodeString((String)role)), RoleResponse.class, Collections.emptyMap(), ErrorHandlers.roleErrorHandler());
        resp.validate();
        return resp.getRole();
    }

    public boolean deleteRole(String role) throws NoSuchMetalakeException {
        DeleteResponse resp = this.restClient.delete(String.format(API_METALAKES_ROLES_PATH, this.name(), RESTUtils.encodeString((String)role)), DeleteResponse.class, Collections.emptyMap(), ErrorHandlers.roleErrorHandler());
        resp.validate();
        return resp.deleted();
    }

    public Role createRole(String role, Map<String, String> properties, List<SecurableObject> securableObjects) throws RoleAlreadyExistsException, NoSuchMetalakeException, IllegalMetadataObjectException {
        RoleCreateRequest req = new RoleCreateRequest(role, properties, (SecurableObjectDTO[])securableObjects.stream().map(DTOConverters::toSecurableObject).toArray(SecurableObjectDTO[]::new));
        req.validate();
        RoleResponse resp = this.restClient.post(String.format(API_METALAKES_ROLES_PATH, this.name(), BLANK_PLACEHOLDER), (RESTRequest)req, RoleResponse.class, Collections.emptyMap(), ErrorHandlers.roleErrorHandler());
        resp.validate();
        return resp.getRole();
    }

    public String[] listRoleNames() {
        NameListResponse resp = this.restClient.get(String.format(API_METALAKES_ROLES_PATH, this.name(), BLANK_PLACEHOLDER), NameListResponse.class, Collections.emptyMap(), ErrorHandlers.roleErrorHandler());
        resp.validate();
        return resp.getNames();
    }

    public User grantRolesToUser(List<String> roles, String user) throws NoSuchUserException, IllegalRoleException, NoSuchMetalakeException {
        RoleGrantRequest request = new RoleGrantRequest(roles);
        request.validate();
        UserResponse resp = this.restClient.put(String.format(API_PERMISSION_PATH, this.name(), String.format("users/%s/grant", RESTUtils.encodeString((String)user))), (RESTRequest)request, UserResponse.class, Collections.emptyMap(), ErrorHandlers.permissionOperationErrorHandler());
        resp.validate();
        return resp.getUser();
    }

    public Group grantRolesToGroup(List<String> roles, String group) throws NoSuchGroupException, NoSuchRoleException, NoSuchMetalakeException {
        RoleGrantRequest request = new RoleGrantRequest(roles);
        request.validate();
        GroupResponse resp = this.restClient.put(String.format(API_PERMISSION_PATH, this.name(), String.format("groups/%s/grant", RESTUtils.encodeString((String)group))), (RESTRequest)request, GroupResponse.class, Collections.emptyMap(), ErrorHandlers.permissionOperationErrorHandler());
        resp.validate();
        return resp.getGroup();
    }

    public User revokeRolesFromUser(List<String> roles, String user) throws NoSuchUserException, NoSuchRoleException, NoSuchMetalakeException {
        RoleRevokeRequest request = new RoleRevokeRequest(roles);
        request.validate();
        UserResponse resp = this.restClient.put(String.format(API_PERMISSION_PATH, this.name(), String.format("users/%s/revoke", RESTUtils.encodeString((String)user))), (RESTRequest)request, UserResponse.class, Collections.emptyMap(), ErrorHandlers.permissionOperationErrorHandler());
        resp.validate();
        return resp.getUser();
    }

    public Group revokeRolesFromGroup(List<String> roles, String group) throws NoSuchGroupException, IllegalRoleException, NoSuchMetalakeException {
        RoleRevokeRequest request = new RoleRevokeRequest(roles);
        request.validate();
        GroupResponse resp = this.restClient.put(String.format(API_PERMISSION_PATH, this.name(), String.format("groups/%s/revoke", RESTUtils.encodeString((String)group))), (RESTRequest)request, GroupResponse.class, Collections.emptyMap(), ErrorHandlers.permissionOperationErrorHandler());
        resp.validate();
        return resp.getGroup();
    }

    public Role grantPrivilegesToRole(String role, MetadataObject object, List<Privilege> privileges) throws NoSuchRoleException, NoSuchMetadataObjectException, NoSuchMetalakeException, IllegalPrivilegeException {
        PrivilegeGrantRequest request = new PrivilegeGrantRequest(DTOConverters.toPrivileges(privileges));
        request.validate();
        RoleResponse resp = this.restClient.put(String.format(API_PERMISSION_PATH, this.name(), String.format("roles/%s/%s/%s/grant", RESTUtils.encodeString((String)role), object.type().name().toLowerCase(Locale.ROOT), object.fullName())), (RESTRequest)request, RoleResponse.class, Collections.emptyMap(), ErrorHandlers.permissionOperationErrorHandler());
        resp.validate();
        return resp.getRole();
    }

    public Role revokePrivilegesFromRole(String role, MetadataObject object, List<Privilege> privileges) throws NoSuchRoleException, NoSuchMetadataObjectException, NoSuchMetalakeException, IllegalPrivilegeException {
        PrivilegeRevokeRequest request = new PrivilegeRevokeRequest(DTOConverters.toPrivileges(privileges));
        request.validate();
        RoleResponse resp = this.restClient.put(String.format(API_PERMISSION_PATH, this.name(), String.format("roles/%s/%s/%s/revoke", RESTUtils.encodeString((String)role), object.type().name().toLowerCase(Locale.ROOT), object.fullName())), (RESTRequest)request, RoleResponse.class, Collections.emptyMap(), ErrorHandlers.permissionOperationErrorHandler());
        resp.validate();
        return resp.getRole();
    }

    public Optional<Owner> getOwner(MetadataObject object) throws NoSuchMetadataObjectException {
        OwnerResponse resp = this.restClient.get(String.format(API_METALAKES_OWNERS_PATH, this.name(), String.format("%s/%s", object.type().name().toLowerCase(Locale.ROOT), RESTUtils.encodeString((String)object.fullName()))), OwnerResponse.class, Collections.emptyMap(), ErrorHandlers.ownerErrorHandler());
        resp.validate();
        return Optional.ofNullable(resp.getOwner());
    }

    public void setOwner(MetadataObject object, String ownerName, Owner.Type ownerType) throws NotFoundException {
        OwnerSetRequest request = new OwnerSetRequest(ownerName, ownerType);
        request.validate();
        SetResponse resp = this.restClient.put(String.format(API_METALAKES_OWNERS_PATH, this.name(), String.format("%s/%s", object.type().name().toLowerCase(Locale.ROOT), RESTUtils.encodeString((String)object.fullName()))), (RESTRequest)request, SetResponse.class, Collections.emptyMap(), ErrorHandlers.ownerErrorHandler());
        resp.validate();
    }

    public String[] listBindingRoleNames() {
        return this.metadataObjectRoleOperations.listBindingRoleNames();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GravitinoMetalake)) {
            return false;
        }
        GravitinoMetalake that = (GravitinoMetalake)((Object)o);
        return super.equals((Object)that);
    }

    public static Builder builder() {
        return new Builder();
    }

    static class Builder
    extends MetalakeDTO.Builder<Builder> {
        private RESTClient restClient;

        private Builder() {
        }

        Builder withRestClient(RESTClient restClient) {
            this.restClient = restClient;
            return this;
        }

        public GravitinoMetalake build() {
            Preconditions.checkNotNull((Object)this.restClient, (Object)"restClient must be set");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.name), (Object)"name must not be null or empty");
            Preconditions.checkArgument((this.audit != null ? 1 : 0) != 0, (Object)"audit must not be null");
            return new GravitinoMetalake(this.name, this.comment, this.properties, this.audit, this.restClient);
        }
    }
}

