/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.requests;

import java.util.Arrays;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.gravitino.dto.authorization.SecurableObjectDTO;
import org.apache.gravitino.rest.RESTRequest;
import org.apache.gravitino.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.gravitino.shaded.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.gravitino.shaded.com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import org.apache.gravitino.shaded.com.google.common.base.Preconditions;
import org.apache.gravitino.shaded.org.apache.commons.lang3.StringUtils;

@JsonDeserialize(builder=RoleCreateRequestBuilder.class)
public class RoleCreateRequest
implements RESTRequest {
    @JsonProperty(value="name")
    private final String name;
    @Nullable
    @JsonProperty(value="properties")
    private Map<String, String> properties;
    @JsonProperty(value="securableObjects")
    private SecurableObjectDTO[] securableObjects;

    public RoleCreateRequest() {
        this(null, null, null);
    }

    public RoleCreateRequest(String name, Map<String, String> properties, SecurableObjectDTO[] securableObjects) {
        this.name = name;
        this.properties = properties;
        this.securableObjects = securableObjects;
    }

    @Override
    public void validate() throws IllegalArgumentException {
        Preconditions.checkArgument(StringUtils.isNotBlank(this.name), "\"name\" field is required and cannot be empty");
        Preconditions.checkArgument(this.securableObjects != null, "\"securableObjects\" can't null ");
        for (SecurableObjectDTO objectDTO : this.securableObjects) {
            Preconditions.checkArgument(StringUtils.isNotBlank(objectDTO.name()), "\" securable object name\" can't be blank");
            Preconditions.checkArgument(objectDTO.type() != null, "\" securable object type\" can't be null");
            Preconditions.checkArgument(objectDTO.privileges() != null && !objectDTO.privileges().isEmpty(), "\"securable object privileges\" can't be null or empty");
        }
    }

    public static RoleCreateRequestBuilder builder() {
        return new RoleCreateRequestBuilder();
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public SecurableObjectDTO[] getSecurableObjects() {
        return this.securableObjects;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RoleCreateRequest)) {
            return false;
        }
        RoleCreateRequest other = (RoleCreateRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Map<String, String> this$properties = this.getProperties();
        Map<String, String> other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        return Arrays.deepEquals(this.getSecurableObjects(), other.getSecurableObjects());
    }

    protected boolean canEqual(Object other) {
        return other instanceof RoleCreateRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Map<String, String> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getSecurableObjects());
        return result;
    }

    public String toString() {
        return "RoleCreateRequest(name=" + this.getName() + ", properties=" + this.getProperties() + ", securableObjects=" + Arrays.deepToString(this.getSecurableObjects()) + ")";
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class RoleCreateRequestBuilder {
        private String name;
        private Map<String, String> properties;
        private SecurableObjectDTO[] securableObjects;

        RoleCreateRequestBuilder() {
        }

        @JsonProperty(value="name")
        public RoleCreateRequestBuilder name(String name) {
            this.name = name;
            return this;
        }

        @JsonProperty(value="properties")
        public RoleCreateRequestBuilder properties(@Nullable Map<String, String> properties) {
            this.properties = properties;
            return this;
        }

        @JsonProperty(value="securableObjects")
        public RoleCreateRequestBuilder securableObjects(SecurableObjectDTO[] securableObjects) {
            this.securableObjects = securableObjects;
            return this;
        }

        public RoleCreateRequest build() {
            return new RoleCreateRequest(this.name, this.properties, this.securableObjects);
        }

        public String toString() {
            return "RoleCreateRequest.RoleCreateRequestBuilder(name=" + this.name + ", properties=" + this.properties + ", securableObjects=" + Arrays.deepToString(this.securableObjects) + ")";
        }
    }
}

