/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.responses;

import org.apache.gravitino.dto.authorization.UserDTO;
import org.apache.gravitino.dto.responses.BaseResponse;
import org.apache.gravitino.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.gravitino.shaded.com.google.common.base.Preconditions;
import org.apache.gravitino.shaded.org.apache.commons.lang3.StringUtils;

public class UserResponse
extends BaseResponse {
    @JsonProperty(value="user")
    private final UserDTO user;

    public UserResponse(UserDTO user) {
        super(0);
        this.user = user;
    }

    public UserResponse() {
        this.user = null;
    }

    @Override
    public void validate() throws IllegalArgumentException {
        super.validate();
        Preconditions.checkArgument(this.user != null, "user must not be null");
        Preconditions.checkArgument(StringUtils.isNotBlank(this.user.name()), "user 'name' must not be null and empty");
        Preconditions.checkArgument(this.user.auditInfo() != null, "user 'auditInfo' must not be null");
    }

    public UserDTO getUser() {
        return this.user;
    }

    @Override
    public String toString() {
        return "UserResponse(user=" + this.getUser() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserResponse)) {
            return false;
        }
        UserResponse other = (UserResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UserDTO this$user = this.getUser();
        UserDTO other$user = other.getUser();
        return !(this$user == null ? other$user != null : !this$user.equals(other$user));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof UserResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        UserDTO $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        return result;
    }
}

