/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.warehouse.store;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.Optional;
import org.apache.hertzbeat.common.entity.manager.Monitor;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.common.queue.CommonDataQueue;
import org.apache.hertzbeat.plugin.PostCollectPlugin;
import org.apache.hertzbeat.plugin.runner.PluginRunner;
import org.apache.hertzbeat.warehouse.WarehouseWorkerPool;
import org.apache.hertzbeat.warehouse.store.history.HistoryDataWriter;
import org.apache.hertzbeat.warehouse.store.realtime.RealTimeDataWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

@Component
public class DataStorageDispatch {
    private static final Logger log = LoggerFactory.getLogger(DataStorageDispatch.class);
    private final CommonDataQueue commonDataQueue;
    private final WarehouseWorkerPool workerPool;
    private final JdbcTemplate jdbcTemplate;
    private final RealTimeDataWriter realTimeDataWriter;
    private final Optional<HistoryDataWriter> historyDataWriter;
    private final PluginRunner pluginRunner;
    @PersistenceContext
    private EntityManager entityManager;

    public DataStorageDispatch(CommonDataQueue commonDataQueue, WarehouseWorkerPool workerPool, JdbcTemplate jdbcTemplate, Optional<HistoryDataWriter> historyDataWriter, RealTimeDataWriter realTimeDataWriter, PluginRunner pluginRunner) {
        this.commonDataQueue = commonDataQueue;
        this.workerPool = workerPool;
        this.jdbcTemplate = jdbcTemplate;
        this.realTimeDataWriter = realTimeDataWriter;
        this.historyDataWriter = historyDataWriter;
        this.pluginRunner = pluginRunner;
        this.startPersistentDataStorage();
    }

    protected void startPersistentDataStorage() {
        Runnable runnable = () -> {
            Thread.currentThread().setName("warehouse-persistent-data-storage");
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    CollectRep.MetricsData metricsData = this.commonDataQueue.pollMetricsDataToStorage();
                    if (metricsData == null) continue;
                    try {
                        this.calculateMonitorStatus(metricsData);
                        this.historyDataWriter.ifPresent(dataWriter -> dataWriter.saveData(metricsData));
                        this.pluginRunner.pluginExecute(PostCollectPlugin.class, (postCollectPlugin, pluginContext) -> postCollectPlugin.execute(metricsData, pluginContext));
                    }
                    finally {
                        this.realTimeDataWriter.saveData(metricsData);
                    }
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        };
        this.workerPool.executeJob(runnable);
    }

    protected void calculateMonitorStatus(CollectRep.MetricsData metricsData) {
        if (metricsData.getPriority() == 0) {
            long id = metricsData.getId();
            CollectRep.Code code = metricsData.getCode();
            try {
                String sql = "UPDATE hzb_monitor SET status = ? WHERE id = ? AND status = ?";
                int status = code == CollectRep.Code.SUCCESS ? 1 : 2;
                int preStatus = code == CollectRep.Code.SUCCESS ? 2 : 1;
                int matchedRows = this.jdbcTemplate.update(sql, new Object[]{status, id, preStatus});
                if (matchedRows > 0) {
                    this.entityManager.getEntityManagerFactory().getCache().evict(Monitor.class, (Object)id);
                }
            }
            catch (Exception e) {
                log.error("Update monitor status failed for monitor id: {}", (Object)id, (Object)e);
            }
        }
    }
}

