/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.pojo.dto;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;
import org.apache.hertzbeat.manager.pojo.dto.AiMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.codec.ServerSentEvent;

public class OpenAiResponse {
    private static final Logger log = LoggerFactory.getLogger(OpenAiResponse.class);
    private String id;
    private Long created;
    private List<Choice> choices;
    private Tokens usage;

    public static ServerSentEvent<String> convertToResponse(String aiRes) {
        try {
            OpenAiResponse openAiResponse = JSON.parseObject(aiRes, OpenAiResponse.class);
            if (Objects.nonNull(openAiResponse)) {
                Choice choice = openAiResponse.getChoices().get(0);
                String content = choice.getDelta().getContent();
                return ServerSentEvent.builder().data(content).build();
            }
        }
        catch (Exception e) {
            log.info("convertToResponse Exception:{}", (Object)e.toString());
            throw e;
        }
        return ServerSentEvent.builder().build();
    }

    public String getId() {
        return this.id;
    }

    public Long getCreated() {
        return this.created;
    }

    public List<Choice> getChoices() {
        return this.choices;
    }

    public Tokens getUsage() {
        return this.usage;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setCreated(Long created) {
        this.created = created;
    }

    public void setChoices(List<Choice> choices) {
        this.choices = choices;
    }

    public void setUsage(Tokens usage) {
        this.usage = usage;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OpenAiResponse)) {
            return false;
        }
        OpenAiResponse other = (OpenAiResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        List<Choice> this$choices = this.getChoices();
        List<Choice> other$choices = other.getChoices();
        if (this$choices == null ? other$choices != null : !((Object)this$choices).equals(other$choices)) {
            return false;
        }
        Tokens this$usage = this.getUsage();
        Tokens other$usage = other.getUsage();
        return !(this$usage == null ? other$usage != null : !((Object)this$usage).equals(other$usage));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OpenAiResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        List<Choice> $choices = this.getChoices();
        result = result * 59 + ($choices == null ? 43 : ((Object)$choices).hashCode());
        Tokens $usage = this.getUsage();
        result = result * 59 + ($usage == null ? 43 : ((Object)$usage).hashCode());
        return result;
    }

    public String toString() {
        return "OpenAiResponse(id=" + this.getId() + ", created=" + this.getCreated() + ", choices=" + this.getChoices() + ", usage=" + this.getUsage() + ")";
    }

    public OpenAiResponse(String id, Long created, List<Choice> choices, Tokens usage) {
        this.id = id;
        this.created = created;
        this.choices = choices;
        this.usage = usage;
    }

    public OpenAiResponse() {
    }

    public class Choice {
        private int index;
        private AiMessage delta;

        public int getIndex() {
            return this.index;
        }

        public AiMessage getDelta() {
            return this.delta;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public void setDelta(AiMessage delta) {
            this.delta = delta;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Choice)) {
                return false;
            }
            Choice other = (Choice)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getIndex() != other.getIndex()) {
                return false;
            }
            AiMessage this$delta = this.getDelta();
            AiMessage other$delta = other.getDelta();
            return !(this$delta == null ? other$delta != null : !((Object)this$delta).equals(other$delta));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Choice;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getIndex();
            AiMessage $delta = this.getDelta();
            result = result * 59 + ($delta == null ? 43 : ((Object)$delta).hashCode());
            return result;
        }

        public String toString() {
            return "OpenAiResponse.Choice(index=" + this.getIndex() + ", delta=" + this.getDelta() + ")";
        }

        public Choice(int index, AiMessage delta) {
            this.index = index;
            this.delta = delta;
        }

        public Choice() {
        }
    }

    public class Tokens {
        @JsonProperty(value="prompt_tokens")
        private Integer promptTokens;
        @JsonProperty(value="completion_tokens")
        private Integer completionTokens;
        @JsonProperty(value="total_tokens")
        private Integer totalTokens;

        public Integer getPromptTokens() {
            return this.promptTokens;
        }

        public Integer getCompletionTokens() {
            return this.completionTokens;
        }

        public Integer getTotalTokens() {
            return this.totalTokens;
        }

        @JsonProperty(value="prompt_tokens")
        public void setPromptTokens(Integer promptTokens) {
            this.promptTokens = promptTokens;
        }

        @JsonProperty(value="completion_tokens")
        public void setCompletionTokens(Integer completionTokens) {
            this.completionTokens = completionTokens;
        }

        @JsonProperty(value="total_tokens")
        public void setTotalTokens(Integer totalTokens) {
            this.totalTokens = totalTokens;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Tokens)) {
                return false;
            }
            Tokens other = (Tokens)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$promptTokens = this.getPromptTokens();
            Integer other$promptTokens = other.getPromptTokens();
            if (this$promptTokens == null ? other$promptTokens != null : !((Object)this$promptTokens).equals(other$promptTokens)) {
                return false;
            }
            Integer this$completionTokens = this.getCompletionTokens();
            Integer other$completionTokens = other.getCompletionTokens();
            if (this$completionTokens == null ? other$completionTokens != null : !((Object)this$completionTokens).equals(other$completionTokens)) {
                return false;
            }
            Integer this$totalTokens = this.getTotalTokens();
            Integer other$totalTokens = other.getTotalTokens();
            return !(this$totalTokens == null ? other$totalTokens != null : !((Object)this$totalTokens).equals(other$totalTokens));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Tokens;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $promptTokens = this.getPromptTokens();
            result = result * 59 + ($promptTokens == null ? 43 : ((Object)$promptTokens).hashCode());
            Integer $completionTokens = this.getCompletionTokens();
            result = result * 59 + ($completionTokens == null ? 43 : ((Object)$completionTokens).hashCode());
            Integer $totalTokens = this.getTotalTokens();
            result = result * 59 + ($totalTokens == null ? 43 : ((Object)$totalTokens).hashCode());
            return result;
        }

        public String toString() {
            return "OpenAiResponse.Tokens(promptTokens=" + this.getPromptTokens() + ", completionTokens=" + this.getCompletionTokens() + ", totalTokens=" + this.getTotalTokens() + ")";
        }

        public Tokens(Integer promptTokens, Integer completionTokens, Integer totalTokens) {
            this.promptTokens = promptTokens;
            this.completionTokens = completionTokens;
            this.totalTokens = totalTokens;
        }

        public Tokens() {
        }
    }
}

