/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.scheduler.netty.process;

import io.netty.channel.ChannelHandlerContext;
import org.apache.hertzbeat.common.entity.message.ClusterMsg;
import org.apache.hertzbeat.manager.scheduler.netty.ManageServer;
import org.apache.hertzbeat.remoting.netty.NettyRemotingProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeartbeatProcessor
implements NettyRemotingProcessor {
    private static final Logger log = LoggerFactory.getLogger(HeartbeatProcessor.class);
    private final ManageServer manageServer;

    public HeartbeatProcessor(ManageServer manageServer) {
        this.manageServer = manageServer;
    }

    @Override
    public ClusterMsg.Message handle(ChannelHandlerContext ctx, ClusterMsg.Message message) {
        String identity = message.getIdentity();
        boolean isChannelActive = this.manageServer.isChannelActive(identity);
        if (!isChannelActive) {
            this.manageServer.addChannel(identity, ctx.channel());
            isChannelActive = this.manageServer.isChannelActive(identity);
            if (!isChannelActive) {
                log.info("the collector {} is not online.", (Object)identity);
                return null;
            }
            this.manageServer.getCollectorAndJobScheduler().collectorGoOnline(identity, null);
        }
        if (log.isDebugEnabled()) {
            log.debug("server receive collector {} heartbeat", (Object)message.getIdentity());
        }
        return ClusterMsg.Message.newBuilder().setType(ClusterMsg.MessageType.HEARTBEAT).build();
    }
}

