/*
 * Decompiled with CFR 0.152.
 */
package io.greptime.limit;

import io.greptime.errors.LimitedException;
import io.greptime.limit.Limiter;
import java.util.concurrent.TimeUnit;

public interface LimitedPolicy {
    public boolean acquire(Limiter var1, int var2);

    public static LimitedPolicy defaultWriteLimitedPolicy() {
        return new AbortOnBlockingTimeoutPolicy(3L, TimeUnit.SECONDS);
    }

    public static class AbortOnBlockingTimeoutPolicy
    extends BlockingTimeoutPolicy {
        public AbortOnBlockingTimeoutPolicy(long timeout, TimeUnit unit) {
            super(timeout, unit);
        }

        @Override
        public boolean acquire(Limiter limiter, int permits) {
            if (super.acquire(limiter, permits)) {
                return true;
            }
            String err = String.format("Limited by `AbortOnBlockingTimeoutPolicy[timeout=%d, unit=%s]`, acquirePermits=%d, maxPermits=%d, availablePermits=%d.", new Object[]{this.timeout(), this.unit(), permits, limiter.maxPermits(), limiter.availablePermits()});
            throw new LimitedException(err);
        }
    }

    public static class BlockingTimeoutPolicy
    implements LimitedPolicy {
        private final long timeout;
        private final TimeUnit unit;

        public BlockingTimeoutPolicy(long timeout, TimeUnit unit) {
            this.timeout = timeout;
            this.unit = unit;
        }

        @Override
        public boolean acquire(Limiter limiter, int permits) {
            return limiter.tryAcquire(permits, this.timeout, this.unit);
        }

        public long timeout() {
            return this.timeout;
        }

        public TimeUnit unit() {
            return this.unit;
        }
    }

    public static class BlockingPolicy
    implements LimitedPolicy {
        @Override
        public boolean acquire(Limiter limiter, int permits) {
            limiter.acquire(permits);
            return true;
        }
    }

    public static class AbortPolicy
    implements LimitedPolicy {
        @Override
        public boolean acquire(Limiter limiter, int permits) {
            if (limiter.tryAcquire(permits)) {
                return true;
            }
            String err = String.format("Limited by `AbortPolicy`, acquirePermits=%d, maxPermits=%d, availablePermits=%d.", permits, limiter.maxPermits(), limiter.availablePermits());
            throw new LimitedException(err);
        }
    }

    public static class DiscardPolicy
    implements LimitedPolicy {
        @Override
        public boolean acquire(Limiter limiter, int permits) {
            return limiter.tryAcquire(permits);
        }
    }
}

