/*
 * Decompiled with CFR 0.152.
 */
package io.greptime.common.util;

import io.greptime.common.SPI;
import io.greptime.common.util.Ensures;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.ServiceConfigurationError;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServiceLoader<S>
implements Iterable<S> {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceLoader.class);
    private static final String PREFIX = "META-INF/services/";
    private final Class<S> service;
    private final ClassLoader loader;
    private final LinkedHashMap<String, S> providers = new LinkedHashMap();
    private LazyIterator lookupIterator;

    public static <S> ServiceLoader<S> load(Class<S> service) {
        return ServiceLoader.load(service, ServiceLoader.class.getClassLoader());
    }

    public static <S> ServiceLoader<S> load(Class<S> service, ClassLoader loader) {
        return new ServiceLoader<S>(service, loader);
    }

    public List<S> sort() {
        Iterator<S> it = this.iterator();
        ArrayList<S> sortList = new ArrayList<S>();
        while (it.hasNext()) {
            sortList.add(it.next());
        }
        if (sortList.size() <= 1) {
            return sortList;
        }
        sortList.sort((o1, o2) -> {
            SPI o1Spi = o1.getClass().getAnnotation(SPI.class);
            SPI o2Spi = o2.getClass().getAnnotation(SPI.class);
            int o1Priority = o1Spi == null ? 0 : o1Spi.priority();
            int o2Priority = o2Spi == null ? 0 : o2Spi.priority();
            return -(o1Priority - o2Priority);
        });
        return sortList;
    }

    public S first() {
        Class<S> first = this.firstClass();
        if (first == null) {
            throw ServiceLoader.fail(this.service, "could not find any implementation for class");
        }
        return this.getOrCreateProvider(first);
    }

    public S firstOrDefault(Supplier<S> supplier) {
        Class<S> first = this.firstClass();
        return first != null ? this.getOrCreateProvider(first) : supplier.get();
    }

    public Class<S> firstClass() {
        Iterator<Class<S>> it = this.classIterator();
        Class<S> first = null;
        while (it.hasNext()) {
            int currPriority;
            Class<S> cls = it.next();
            if (first == null) {
                first = cls;
                continue;
            }
            SPI currSpi = first.getAnnotation(SPI.class);
            SPI nextSpi = cls.getAnnotation(SPI.class);
            int nextPriority = nextSpi == null ? 0 : nextSpi.priority();
            if (nextPriority <= (currPriority = currSpi == null ? 0 : currSpi.priority())) continue;
            first = cls;
        }
        return first;
    }

    public S find(String implName) {
        for (S s : this.providers.values()) {
            SPI spi = s.getClass().getAnnotation(SPI.class);
            if (spi == null || !spi.name().equalsIgnoreCase(implName)) continue;
            return s;
        }
        while (this.lookupIterator.hasNext()) {
            Object cls = this.lookupIterator.next();
            SPI spi = ((Class)cls).getAnnotation(SPI.class);
            if (spi == null || !spi.name().equalsIgnoreCase(implName)) continue;
            try {
                return this.newProvider((Class<S>)cls);
            }
            catch (Throwable x) {
                throw ServiceLoader.fail(this.service, "provider " + ((Class)cls).getName() + " could not be instantiated", x);
            }
        }
        throw ServiceLoader.fail(this.service, "provider " + implName + " not found");
    }

    public void reload() {
        this.providers.clear();
        this.lookupIterator = new LazyIterator(this.service, this.loader);
    }

    private ServiceLoader(Class<S> service, ClassLoader loader) {
        this.service = Ensures.ensureNonNull(service, "service interface cannot be null");
        this.loader = loader == null ? ClassLoader.getSystemClassLoader() : loader;
        this.reload();
    }

    private static ServiceConfigurationError fail(Class<?> service, String msg, Throwable cause) {
        return new ServiceConfigurationError(service.getName() + ": " + msg, cause);
    }

    private static ServiceConfigurationError fail(Class<?> service, String msg) {
        return new ServiceConfigurationError(service.getName() + ": " + msg);
    }

    private static ServiceConfigurationError fail(Class<?> service, URL url, int line, String msg) {
        return ServiceLoader.fail(service, url + ":" + line + ": " + msg);
    }

    private int parseLine(Class<?> service, URL u, BufferedReader r, int lc, List<String> names) throws IOException, ServiceConfigurationError {
        int n;
        String ln = r.readLine();
        if (ln == null) {
            return -1;
        }
        int ci = ln.indexOf(35);
        if (ci >= 0) {
            ln = ln.substring(0, ci);
        }
        if ((n = (ln = ln.trim()).length()) != 0) {
            if (ln.indexOf(32) >= 0 || ln.indexOf(9) >= 0) {
                throw ServiceLoader.fail(service, u, lc, "illegal configuration-file syntax");
            }
            int cp = ln.codePointAt(0);
            if (!Character.isJavaIdentifierStart(cp)) {
                throw ServiceLoader.fail(service, u, lc, "illegal provider-class name: " + ln);
            }
            for (int i = Character.charCount(cp); i < n; i += Character.charCount(cp)) {
                cp = ln.codePointAt(i);
                if (Character.isJavaIdentifierPart(cp) || cp == 46) continue;
                throw ServiceLoader.fail(service, u, lc, "Illegal provider-class name: " + ln);
            }
            if (!this.providers.containsKey(ln) && !names.contains(ln)) {
                names.add(ln);
            }
        }
        return lc + 1;
    }

    private Iterator<String> parse(Class<?> service, URL url) {
        ArrayList<String> names = new ArrayList<String>();
        try (InputStream in = url.openStream();
             BufferedReader r = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
            int lc = 1;
            while ((lc = this.parseLine(service, url, r, lc, names)) >= 0) {
            }
        }
        catch (IOException x) {
            throw ServiceLoader.fail(service, "error reading configuration file", x);
        }
        return names.iterator();
    }

    @Override
    public Iterator<S> iterator() {
        return new Iterator<S>(){
            final Iterator<Map.Entry<String, S>> knownProviders;
            {
                this.knownProviders = ServiceLoader.this.providers.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.knownProviders.hasNext() || ServiceLoader.this.lookupIterator.hasNext();
            }

            @Override
            public S next() {
                if (this.knownProviders.hasNext()) {
                    return this.knownProviders.next().getValue();
                }
                Object cls = ServiceLoader.this.lookupIterator.next();
                return ServiceLoader.this.newProvider((Class)cls);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Iterator<Class<S>> classIterator() {
        return new Iterator<Class<S>>(){
            final Iterator<Map.Entry<String, S>> knownProviders;
            {
                this.knownProviders = ServiceLoader.this.providers.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.knownProviders.hasNext() || ServiceLoader.this.lookupIterator.hasNext();
            }

            @Override
            public Class<S> next() {
                if (this.knownProviders.hasNext()) {
                    return this.knownProviders.next().getValue().getClass();
                }
                return ServiceLoader.this.lookupIterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private S getOrCreateProvider(Class<S> cls) {
        S ins = this.providers.get(cls.getName());
        if (ins != null) {
            return ins;
        }
        return this.newProvider(cls);
    }

    private S newProvider(Class<S> cls) {
        LOG.info("SPI service [{} - {}] loading.", (Object)this.service.getName(), (Object)cls.getName());
        try {
            S provider = this.service.cast(cls.newInstance());
            this.providers.put(cls.getName(), provider);
            return provider;
        }
        catch (Throwable x) {
            throw ServiceLoader.fail(this.service, "provider " + cls.getName() + " could not be instantiated", x);
        }
    }

    public String toString() {
        return "io.greptime.common.util.ServiceLoader[" + this.service.getName() + "]";
    }

    private class LazyIterator
    implements Iterator<Class<S>> {
        Class<S> service;
        ClassLoader loader;
        Enumeration<URL> configs = null;
        Iterator<String> pending = null;
        String nextName = null;

        private LazyIterator(Class<S> service, ClassLoader loader) {
            this.service = service;
            this.loader = loader;
        }

        @Override
        public boolean hasNext() {
            if (this.nextName != null) {
                return true;
            }
            if (this.configs == null) {
                try {
                    String fullName = ServiceLoader.PREFIX + this.service.getName();
                    this.configs = this.loader == null ? ClassLoader.getSystemResources(fullName) : this.loader.getResources(fullName);
                }
                catch (IOException x) {
                    throw ServiceLoader.fail(this.service, "error locating configuration files", x);
                }
            }
            while (this.pending == null || !this.pending.hasNext()) {
                if (!this.configs.hasMoreElements()) {
                    return false;
                }
                this.pending = ServiceLoader.this.parse(this.service, this.configs.nextElement());
            }
            this.nextName = this.pending.next();
            return true;
        }

        @Override
        public Class<S> next() {
            Class<?> cls;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            String name = this.nextName;
            this.nextName = null;
            try {
                cls = Class.forName(name, false, this.loader);
            }
            catch (ClassNotFoundException x) {
                throw ServiceLoader.fail(this.service, "provider " + name + " not found");
            }
            if (!this.service.isAssignableFrom(cls)) {
                throw ServiceLoader.fail(this.service, "provider " + name + " not a subtype");
            }
            return cls;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

