/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.core.impl;

import com.huaweicloud.sdk.core.http.HttpResponse;
import com.huaweicloud.sdk.core.impl.DefaultHttpUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHttpResponse
implements HttpResponse {
    private static final Logger logger = LoggerFactory.getLogger(DefaultHttpResponse.class);
    private Response response;
    private String strBody;
    private static final String[] SHOULD_READ_BODY_CONTENT_TYPES = new String[]{"application/json", "application/xml", "text"};

    private DefaultHttpResponse(Response response) {
        this.response = response;
        if (this.shouldReadBody()) {
            try {
                this.strBody = response.body().string();
            }
            catch (IOException e) {
                logger.error("Read http response body error!", (Throwable)e);
            }
        }
    }

    private boolean shouldReadBody() {
        if (Objects.isNull(this.response.body())) {
            return false;
        }
        if (Objects.isNull(this.response.body().contentType())) {
            return this.response.body().contentLength() != 0L;
        }
        String contentType = this.response.body().contentType().toString();
        for (String shouldReadBodyContentType : SHOULD_READ_BODY_CONTENT_TYPES) {
            if (!contentType.startsWith(shouldReadBodyContentType)) continue;
            return true;
        }
        return false;
    }

    static DefaultHttpResponse wrap(Response response) {
        return new DefaultHttpResponse(response);
    }

    @Override
    public int getStatusCode() {
        return this.response.code();
    }

    @Override
    public String getContentType() {
        return Objects.isNull(this.response.body()) || Objects.isNull(this.response.body().contentType()) ? null : this.response.body().contentType().toString();
    }

    @Override
    public long getContentLength() {
        return Objects.isNull(this.response.body()) || this.response.body().contentLength() < 0L ? 0L : this.response.body().contentLength();
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        return DefaultHttpUtils.headersToMap(this.response.headers());
    }

    @Override
    public String getBodyAsString() {
        return this.strBody;
    }

    @Override
    public InputStream getBody() {
        return this.response.body().byteStream();
    }

    @Override
    public String getHeader(String name) {
        return this.response.header(name);
    }
}

