/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.service.impl;

import org.apache.hertzbeat.alert.reduce.AlarmCommonReduce;
import org.apache.hertzbeat.alert.service.ExternAlertService;
import org.apache.hertzbeat.common.entity.alerter.SingleAlert;
import org.apache.hertzbeat.common.util.JsonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ZabbixExternAlertServiceImpl
implements ExternAlertService {
    private static final Logger log = LoggerFactory.getLogger(ZabbixExternAlertServiceImpl.class);
    @Autowired
    private AlarmCommonReduce alarmCommonReduce;

    @Override
    public void addExternAlert(String content) {
        SingleAlert alert = (SingleAlert)JsonUtil.fromJson((String)content, SingleAlert.class);
        if (alert == null) {
            log.warn("parse extern alert content failed! content: {}", (Object)content);
            return;
        }
        this.alarmCommonReduce.reduceAndSendAlarm(alert);
    }

    @Override
    public String supportSource() {
        return "zabbix";
    }
}

