/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.grafana.service;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.HashMap;
import java.util.Map;
import org.apache.hertzbeat.common.util.JsonUtil;
import org.apache.hertzbeat.grafana.common.GrafanaConstants;
import org.apache.hertzbeat.grafana.config.GrafanaProperties;
import org.apache.hertzbeat.warehouse.store.history.tsdb.greptime.GreptimeProperties;
import org.apache.hertzbeat.warehouse.store.history.tsdb.vm.VictoriaMetricsProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

@Service
public class DatasourceService {
    private static final Logger log = LoggerFactory.getLogger(DatasourceService.class);
    private final GrafanaProperties grafanaProperties;
    private final VictoriaMetricsProperties warehouseProperties;
    private final GreptimeProperties greptimeProperties;
    private final RestTemplate restTemplate;

    @Autowired
    public DatasourceService(GrafanaProperties grafanaProperties, VictoriaMetricsProperties warehouseProperties, GreptimeProperties greptimeProperties, RestTemplate restTemplate) {
        this.grafanaProperties = grafanaProperties;
        this.warehouseProperties = warehouseProperties;
        this.greptimeProperties = greptimeProperties;
        this.restTemplate = restTemplate;
    }

    public void existOrCreateDatasource(String token) {
        String datasourceUrl;
        String datasourceType;
        boolean vmEnabled = this.warehouseProperties.enabled();
        boolean greptimeEnabled = this.greptimeProperties.enabled();
        if (vmEnabled && greptimeEnabled) {
            throw new IllegalStateException("Conflict: Both VictoriaMetrics and Greptime are enabled, only one can be used for Grafana datasource");
        }
        if (!vmEnabled && !greptimeEnabled) {
            log.info("HertzBeat warehouse config not enabled");
            return;
        }
        if (vmEnabled) {
            datasourceType = "vm";
            datasourceUrl = this.warehouseProperties.url();
        } else {
            datasourceType = "greptime";
            datasourceUrl = this.greptimeProperties.httpEndpoint();
        }
        String datasourceName = GrafanaConstants.generateDatasourceName(datasourceType, datasourceUrl);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setBearerAuth(token);
        String queryUrl = this.grafanaProperties.getPrefix() + this.grafanaProperties.getUrl() + "/api/datasources/name/" + datasourceName;
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(queryUrl, HttpMethod.GET, entity, String.class, new Object[0]);
            if (response.getStatusCode().is2xxSuccessful()) {
                log.info("{} datasource already exists", (Object)datasourceName);
                return;
            }
        }
        catch (HttpClientErrorException.NotFound notFound) {
            log.info("Datasource {} not found, creating new one", (Object)datasourceName);
        }
        catch (Exception e) {
            log.error("Query datasource error", (Throwable)e);
            return;
        }
        this.createDatasource(token, datasourceName, datasourceUrl, datasourceType);
    }

    public void createDatasource(String token, String datasourceName, String datasourceUrl, String datasourceType) {
        DatasourceRequest datasourceRequest;
        String createUrl = this.grafanaProperties.getPrefix() + this.grafanaProperties.getUrl() + "/api/datasources";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setBearerAuth(token);
        if ("greptime".equals(datasourceType)) {
            datasourceUrl = (String)datasourceUrl + "/v1/prometheus";
            HashMap<String, Object> jsonData = new HashMap<String, Object>();
            HashMap<String, Object> secureJsonData = new HashMap<String, Object>();
            jsonData.put("httpHeaderName1", "x-greptime-db-name");
            secureJsonData.put("httpHeaderValue1", this.greptimeProperties.database());
            datasourceRequest = new DatasourceRequest(datasourceName, "prometheus", "proxy", (String)datasourceUrl, false, jsonData, secureJsonData);
        } else {
            datasourceRequest = new DatasourceRequest(datasourceName, "prometheus", "proxy", (String)datasourceUrl, false, null, null);
        }
        try {
            String body = JsonUtil.toJson((Object)datasourceRequest);
            HttpEntity createEntity = new HttpEntity((Object)body, (MultiValueMap)headers);
            ResponseEntity createResponse = this.restTemplate.postForEntity(createUrl, (Object)createEntity, String.class, new Object[0]);
            if (createResponse.getStatusCode().is2xxSuccessful()) {
                log.info("Create datasource success");
            }
        }
        catch (HttpClientErrorException.Conflict conflict) {
            log.info("Datasource already exists");
        }
        catch (Exception e) {
            log.error("Create datasource error", (Throwable)e);
        }
    }

    public String getCurrentDatasourceName() {
        boolean vmEnabled = this.warehouseProperties.enabled();
        boolean greptimeEnabled = this.greptimeProperties.enabled();
        if (vmEnabled) {
            return GrafanaConstants.generateDatasourceName("vm", this.warehouseProperties.url());
        }
        if (greptimeEnabled) {
            return GrafanaConstants.generateDatasourceName("greptime", this.greptimeProperties.httpEndpoint());
        }
        return null;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class DatasourceRequest {
        public String name;
        public String type;
        public String access;
        public String url;
        public boolean basicAuth;
        public Map<String, Object> jsonData;
        public Map<String, Object> secureJsonData;

        public DatasourceRequest(String name, String type, String access, String url, boolean basicAuth, Map<String, Object> jsonData, Map<String, Object> secureJsonData) {
            this.name = name;
            this.type = type;
            this.access = access;
            this.url = url;
            this.basicAuth = basicAuth;
            this.jsonData = jsonData;
            this.secureJsonData = secureJsonData;
        }
    }
}

