/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.apiimpl;

import io.smallrye.faulttolerance.api.Guard;
import io.smallrye.faulttolerance.apiimpl.GuardImpl;
import jakarta.enterprise.util.TypeLiteral;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.function.Supplier;

public final class LazyGuard
implements Guard {
    private final Function<String, GuardImpl> builder;
    private final ReentrantLock lock = new ReentrantLock();
    private volatile GuardImpl instance;

    LazyGuard(Function<String, GuardImpl> builder) {
        this.builder = builder;
    }

    public <T> T call(Callable<T> action, Class<T> type) throws Exception {
        return this.instance(null).call(action, type);
    }

    public <T> T call(Callable<T> action, TypeLiteral<T> type) throws Exception {
        return this.instance(null).call(action, type);
    }

    public <T> T get(Supplier<T> action, Class<T> type) {
        return this.instance(null).get(action, type);
    }

    public <T> T get(Supplier<T> action, TypeLiteral<T> type) {
        return this.instance(null).get(action, type);
    }

    public GuardImpl instance(String identifier) {
        GuardImpl instance = this.instance;
        if (instance == null) {
            this.lock.lock();
            try {
                instance = this.instance;
                if (instance == null) {
                    this.instance = instance = this.builder.apply(identifier);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return instance;
    }
}

