/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.catalog.generic;

import io.smallrye.common.annotation.Identifier;
import jakarta.enterprise.inject.Instance;
import jakarta.ws.rs.core.SecurityContext;
import java.lang.annotation.Annotation;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.polaris.core.auth.PolarisAuthorizableOperation;
import org.apache.polaris.core.auth.PolarisAuthorizer;
import org.apache.polaris.core.catalog.ExternalCatalogFactory;
import org.apache.polaris.core.catalog.GenericTableCatalog;
import org.apache.polaris.core.config.FeatureConfiguration;
import org.apache.polaris.core.config.RealmConfig;
import org.apache.polaris.core.connection.ConnectionConfigInfoDpo;
import org.apache.polaris.core.connection.ConnectionType;
import org.apache.polaris.core.context.CallContext;
import org.apache.polaris.core.entity.CatalogEntity;
import org.apache.polaris.core.entity.PolarisBaseEntity;
import org.apache.polaris.core.entity.PolarisEntitySubType;
import org.apache.polaris.core.entity.table.GenericTableEntity;
import org.apache.polaris.core.persistence.PolarisMetaStoreManager;
import org.apache.polaris.core.persistence.resolver.PolarisResolutionManifestCatalogView;
import org.apache.polaris.core.persistence.resolver.ResolutionManifestFactory;
import org.apache.polaris.core.secrets.UserSecretsManager;
import org.apache.polaris.service.catalog.common.CatalogHandler;
import org.apache.polaris.service.catalog.generic.PolarisGenericTableCatalog;
import org.apache.polaris.service.types.GenericTable;
import org.apache.polaris.service.types.ListGenericTablesResponse;
import org.apache.polaris.service.types.LoadGenericTableResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericTableCatalogHandler
extends CatalogHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(GenericTableCatalogHandler.class);
    private PolarisMetaStoreManager metaStoreManager;
    private GenericTableCatalog genericTableCatalog;

    public GenericTableCatalogHandler(CallContext callContext, ResolutionManifestFactory resolutionManifestFactory, PolarisMetaStoreManager metaStoreManager, SecurityContext securityContext, String catalogName, PolarisAuthorizer authorizer, UserSecretsManager userSecretsManager, Instance<ExternalCatalogFactory> externalCatalogFactories) {
        super(callContext, resolutionManifestFactory, securityContext, catalogName, authorizer, userSecretsManager, externalCatalogFactories);
        this.metaStoreManager = metaStoreManager;
    }

    @Override
    protected void initializeCatalog() {
        CatalogEntity resolvedCatalogEntity = CatalogEntity.of((PolarisBaseEntity)this.resolutionManifest.getResolvedReferenceCatalogEntity().getRawLeafEntity());
        ConnectionConfigInfoDpo connectionConfigInfoDpo = resolvedCatalogEntity.getConnectionConfigInfoDpo();
        if (connectionConfigInfoDpo != null) {
            LOGGER.atInfo().addKeyValue("remoteUrl", (Object)connectionConfigInfoDpo.getUri()).log("Initializing federated catalog");
            FeatureConfiguration.enforceFeatureEnabledOrThrow((RealmConfig)this.callContext.getRealmConfig(), (FeatureConfiguration)FeatureConfiguration.ENABLE_CATALOG_FEDERATION);
            ConnectionType connectionType = ConnectionType.fromCode((int)connectionConfigInfoDpo.getConnectionTypeCode());
            Instance externalCatalogFactory = this.externalCatalogFactories.select(new Annotation[]{Identifier.Literal.of((String)connectionType.getFactoryIdentifier())});
            if (!externalCatalogFactory.isResolvable()) {
                throw new UnsupportedOperationException("External catalog factory for type '" + String.valueOf(connectionType) + "' is unavailable.");
            }
            GenericTableCatalog federatedCatalog = ((ExternalCatalogFactory)externalCatalogFactory.get()).createGenericCatalog(connectionConfigInfoDpo, this.getUserSecretsManager());
            this.genericTableCatalog = federatedCatalog;
        } else {
            LOGGER.atInfo().log("Initializing non-federated catalog");
            this.genericTableCatalog = new PolarisGenericTableCatalog(this.metaStoreManager, this.callContext, (PolarisResolutionManifestCatalogView)this.resolutionManifest);
            this.genericTableCatalog.initialize(this.catalogName, Map.of());
        }
    }

    public ListGenericTablesResponse listGenericTables(Namespace parent) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.LIST_TABLES;
        this.authorizeBasicNamespaceOperationOrThrow(op, parent);
        return ListGenericTablesResponse.builder().setIdentifiers(new LinkedHashSet(this.genericTableCatalog.listGenericTables(parent))).build();
    }

    public LoadGenericTableResponse createGenericTable(TableIdentifier identifier, String format, String baseLocation, String doc, Map<String, String> properties) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.CREATE_TABLE_DIRECT;
        this.authorizeCreateTableLikeUnderNamespaceOperationOrThrow(op, identifier);
        GenericTableEntity createdEntity = this.genericTableCatalog.createGenericTable(identifier, format, baseLocation, doc, properties);
        GenericTable createdTable = GenericTable.builder().setName(createdEntity.getName()).setFormat(createdEntity.getFormat()).setBaseLocation(createdEntity.getBaseLocation()).setDoc(createdEntity.getDoc()).setProperties(createdEntity.getPropertiesAsMap()).build();
        return LoadGenericTableResponse.builder().setTable(createdTable).build();
    }

    public boolean dropGenericTable(TableIdentifier identifier) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.DROP_TABLE_WITHOUT_PURGE;
        this.authorizeCreateTableLikeUnderNamespaceOperationOrThrow(op, identifier);
        return this.genericTableCatalog.dropGenericTable(identifier);
    }

    public LoadGenericTableResponse loadGenericTable(TableIdentifier identifier) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.LOAD_TABLE;
        this.authorizeBasicTableLikeOperationOrThrow(op, PolarisEntitySubType.GENERIC_TABLE, identifier);
        GenericTableEntity loadedEntity = this.genericTableCatalog.loadGenericTable(identifier);
        GenericTable loadedTable = GenericTable.builder().setName(loadedEntity.getName()).setFormat(loadedEntity.getFormat()).setBaseLocation(loadedEntity.getBaseLocation()).setDoc(loadedEntity.getDoc()).setProperties(loadedEntity.getPropertiesAsMap()).build();
        return LoadGenericTableResponse.builder().setTable(loadedTable).build();
    }
}

