/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.config;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class ConfigurationUtils {
    private ConfigurationUtils() {
    }

    static Map<String, Object> convertMap(ObjectMapper objectMapper, Map<String, String> properties) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        for (String configName : properties.keySet()) {
            String json = properties.get(configName);
            try {
                JsonNode node = objectMapper.readTree(json);
                m.put(configName, ConfigurationUtils.configValue(node));
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException("Invalid JSON value for feature configuration: " + configName, e);
            }
        }
        return m;
    }

    static Object configValue(JsonNode node) {
        return switch (node.getNodeType()) {
            case JsonNodeType.BOOLEAN -> node.asBoolean();
            case JsonNodeType.STRING -> node.asText();
            case JsonNodeType.NUMBER -> {
                switch (node.numberType()) {
                    case INT: 
                    case LONG: {
                        yield node.asLong();
                    }
                    case FLOAT: 
                    case DOUBLE: {
                        yield node.asDouble();
                    }
                }
                throw new IllegalArgumentException("Unsupported number type: " + String.valueOf(node.numberType()));
            }
            case JsonNodeType.ARRAY -> {
                ArrayList list = new ArrayList();
                node.elements().forEachRemaining(n -> list.add(ConfigurationUtils.configValue(n)));
                yield List.copyOf(list);
            }
            default -> throw new IllegalArgumentException("Unsupported feature configuration JSON type: " + String.valueOf(node.getNodeType()));
        };
    }
}

