/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.metrics;

import io.micrometer.common.annotation.ValueExpressionResolver;
import io.micrometer.common.lang.Nullable;
import jakarta.annotation.Nonnull;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.core.SecurityContext;
import org.apache.polaris.core.context.RealmContext;
import org.apache.polaris.service.metrics.MetricsConfiguration;

@ApplicationScoped
public class PolarisValueExpressionResolver
implements ValueExpressionResolver {
    @Inject
    MetricsConfiguration metricsConfiguration;

    @Nullable
    public String resolve(@Nonnull String expression, @Nullable Object parameter) {
        if (this.metricsConfiguration.realmIdTag().enableInApiMetrics() && parameter instanceof RealmContext) {
            RealmContext realmContext = (RealmContext)parameter;
            if (expression.equals("realmIdentifier")) {
                return realmContext.getRealmIdentifier();
            }
        }
        if (this.metricsConfiguration.userPrincipalTag().enableInApiMetrics() && parameter instanceof SecurityContext) {
            SecurityContext securityContext = (SecurityContext)parameter;
            if (expression.equals("userPrincipal") && securityContext.getUserPrincipal() != null) {
                return securityContext.getUserPrincipal().getName();
            }
        }
        return null;
    }
}

