/*
 * Decompiled with CFR 0.152.
 */
package coursier.shaded.org.jsoup.helper;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

public final class StringUtil {
    private static final String[] padding = new String[]{"", " ", "  ", "   ", "    ", "     ", "      ", "       ", "        ", "         ", "          "};

    public static String join(Collection strings, String sep) {
        return StringUtil.join(strings.iterator(), sep);
    }

    public static String join(Iterator strings, String sep) {
        if (!strings.hasNext()) {
            return "";
        }
        String start2 = strings.next().toString();
        if (!strings.hasNext()) {
            return start2;
        }
        StringBuilder sb = new StringBuilder(64).append(start2);
        while (strings.hasNext()) {
            sb.append(sep);
            sb.append(strings.next());
        }
        return sb.toString();
    }

    public static String padding(int width) {
        if (width < 0) {
            throw new IllegalArgumentException("width must be > 0");
        }
        if (width < padding.length) {
            return padding[width];
        }
        char[] out2 = new char[width];
        for (int i = 0; i < width; ++i) {
            out2[i] = 32;
        }
        return String.valueOf(out2);
    }

    public static boolean isBlank(String string2) {
        if (string2 == null || string2.length() == 0) {
            return true;
        }
        int l = string2.length();
        for (int i = 0; i < l; ++i) {
            if (StringUtil.isWhitespace(string2.codePointAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumeric(String string2) {
        if (string2 == null || string2.length() == 0) {
            return false;
        }
        int l = string2.length();
        for (int i = 0; i < l; ++i) {
            if (Character.isDigit(string2.codePointAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isWhitespace(int c) {
        return c == 32 || c == 9 || c == 10 || c == 12 || c == 13;
    }

    public static String normaliseWhitespace(String string2) {
        StringBuilder sb = new StringBuilder(string2.length());
        StringUtil.appendNormalisedWhitespace(sb, string2, false);
        return sb.toString();
    }

    public static void appendNormalisedWhitespace(StringBuilder accum, String string2, boolean stripLeading) {
        int c;
        boolean lastWasWhite = false;
        boolean reachedNonWhite = false;
        int len2 = string2.length();
        for (int i = 0; i < len2; i += Character.charCount(c)) {
            c = string2.codePointAt(i);
            if (StringUtil.isWhitespace(c)) {
                if (stripLeading && !reachedNonWhite || lastWasWhite) continue;
                accum.append(' ');
                lastWasWhite = true;
                continue;
            }
            accum.appendCodePoint(c);
            lastWasWhite = false;
            reachedNonWhite = true;
        }
    }

    public static boolean in(String needle, String ... haystack) {
        for (String hay : haystack) {
            if (!hay.equals(needle)) continue;
            return true;
        }
        return false;
    }

    public static boolean inSorted(String needle, String[] haystack) {
        return Arrays.binarySearch(haystack, needle) >= 0;
    }

    public static URL resolve(URL base, String relUrl) throws MalformedURLException {
        if (relUrl.startsWith("?")) {
            relUrl = base.getPath() + relUrl;
        }
        if (relUrl.indexOf(46) == 0 && base.getFile().indexOf(47) != 0) {
            base = new URL(base.getProtocol(), base.getHost(), base.getPort(), "/" + base.getFile());
        }
        return new URL(base, relUrl);
    }

    public static String resolve(String baseUrl, String relUrl) {
        try {
            URL base;
            try {
                base = new URL(baseUrl);
            }
            catch (MalformedURLException e) {
                URL abs = new URL(relUrl);
                return abs.toExternalForm();
            }
            return StringUtil.resolve(base, relUrl).toExternalForm();
        }
        catch (MalformedURLException e) {
            return "";
        }
    }
}

