/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util.concurrent;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.concurrent.FailureCallback;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureCallback;
import org.springframework.util.concurrent.ListenableFutureCallbackRegistry;
import org.springframework.util.concurrent.SuccessCallback;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoProcessor;

public class MonoToListenableFutureAdapter<T>
implements ListenableFuture<T> {
    private final MonoProcessor<T> processor;
    private final ListenableFutureCallbackRegistry<T> registry = new ListenableFutureCallbackRegistry();

    public MonoToListenableFutureAdapter(Mono<T> mono2) {
        Assert.notNull(mono2, "Mono must not be null");
        this.processor = mono2.doOnSuccess(this.registry::success).doOnError(this.registry::failure).toProcessor();
    }

    @Override
    @Nullable
    public T get() {
        return (T)this.processor.block();
    }

    @Override
    @Nullable
    public T get(long timeout, TimeUnit unit2) {
        Assert.notNull((Object)unit2, "TimeUnit must not be null");
        Duration duration = Duration.ofMillis(TimeUnit.MILLISECONDS.convert(timeout, unit2));
        return (T)this.processor.block(duration);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.isCancelled()) {
            return false;
        }
        this.processor.cancel();
        return this.processor.isCancelled();
    }

    @Override
    public boolean isCancelled() {
        return this.processor.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.processor.isTerminated();
    }

    @Override
    public void addCallback(ListenableFutureCallback<? super T> callback) {
        this.registry.addCallback(callback);
    }

    @Override
    public void addCallback(SuccessCallback<? super T> success2, FailureCallback failure2) {
        this.registry.addSuccessCallback(success2);
        this.registry.addFailureCallback(failure2);
    }
}

