/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SocketChannel;
import zmq.io.Metadata;
import zmq.util.Wire;

public class Msg {
    public static final int MORE = 1;
    public static final int COMMAND = 2;
    public static final int CREDENTIAL = 32;
    public static final int IDENTITY = 64;
    public static final int SHARED = 128;
    private Metadata metadata;
    private int flags;
    private Type type;
    private SocketChannel fileDesc;
    private int size;
    private byte[] data;
    private final ByteBuffer buf;
    private int writeIndex = 0;
    private int readIndex = 0;

    public Msg() {
        this(0);
    }

    public Msg(int capacity) {
        this.type = Type.DATA;
        this.flags = 0;
        this.size = capacity;
        this.buf = ByteBuffer.wrap(new byte[capacity]).order(ByteOrder.BIG_ENDIAN);
        this.data = this.buf.array();
    }

    public Msg(byte[] src) {
        if (src == null) {
            src = new byte[]{};
        }
        this.type = Type.DATA;
        this.flags = 0;
        this.size = src.length;
        this.data = src;
        this.buf = ByteBuffer.wrap(src).order(ByteOrder.BIG_ENDIAN);
    }

    public Msg(ByteBuffer src) {
        if (src == null) {
            throw new IllegalArgumentException("ByteBuffer cannot be null");
        }
        this.type = Type.DATA;
        this.flags = 0;
        this.buf = src.duplicate();
        this.data = (byte[])(this.buf.hasArray() && this.buf.position() == 0 && this.buf.limit() == this.buf.capacity() ? this.buf.array() : null);
        this.size = this.buf.remaining();
    }

    public Msg(Msg m) {
        if (m == null) {
            throw new IllegalArgumentException("Msg cannot be null");
        }
        this.type = m.type;
        this.flags = m.flags;
        this.size = m.size;
        ByteBuffer byteBuffer = this.buf = m.buf != null ? m.buf.duplicate() : null;
        if (m.data != null) {
            this.data = new byte[this.size];
            System.arraycopy(m.data, 0, this.data, 0, m.size);
        }
    }

    private Msg(Msg src, ByteArrayOutputStream out2) {
        this(ByteBuffer.wrap(out2.toByteArray()));
        this.type = src.type;
        this.flags = src.flags;
    }

    public boolean isIdentity() {
        return (this.flags & 0x40) == 64;
    }

    public boolean isDelimiter() {
        return this.type == Type.DELIMITER;
    }

    public boolean check() {
        return true;
    }

    public int flags() {
        return this.flags;
    }

    public boolean hasMore() {
        return (this.flags & 1) > 0;
    }

    public boolean isCommand() {
        return (this.flags & 2) == 2;
    }

    public boolean isCredential() {
        return (this.flags & 0x20) == 32;
    }

    public void setFlags(int flags) {
        this.flags |= flags;
    }

    public void initDelimiter() {
        this.type = Type.DELIMITER;
        this.metadata = null;
        this.flags = 0;
    }

    public byte[] data() {
        if (this.data == null) {
            this.data = new byte[this.buf.remaining()];
            this.buf.duplicate().get(this.data);
        }
        return this.data;
    }

    public ByteBuffer buf() {
        return this.buf.duplicate();
    }

    public int size() {
        return this.size;
    }

    public void resetFlags(int f2) {
        this.flags &= ~f2;
    }

    public void setFd(SocketChannel fileDesc) {
        this.fileDesc = fileDesc;
    }

    public SocketChannel fd() {
        return this.fileDesc;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public Msg setMetadata(Metadata metadata) {
        this.metadata = metadata;
        return this;
    }

    public void resetMetadata() {
        this.setMetadata(null);
    }

    public byte get() {
        return this.get(this.readIndex++);
    }

    public byte get(int index2) {
        return this.buf.get(index2);
    }

    public Msg put(byte b2) {
        return this.put(this.writeIndex++, b2);
    }

    public Msg put(int b2) {
        return this.put(this.writeIndex++, (byte)b2);
    }

    protected Msg put(int index2, byte b2) {
        this.buf.put(index2, b2);
        return this;
    }

    public Msg put(byte[] src) {
        return this.put(src, 0, src.length);
    }

    public Msg put(byte[] src, int off, int len2) {
        if (src == null) {
            return this;
        }
        ByteBuffer dup2 = this.buf.duplicate();
        dup2.position(this.writeIndex);
        this.writeIndex += len2;
        dup2.put(src, off, len2);
        return this;
    }

    public Msg put(ByteBuffer src, int off, int len2) {
        if (src == null) {
            return this;
        }
        int position = src.position();
        int limit2 = src.limit();
        src.limit(off + len2).position(off);
        this.put(src);
        src.limit(limit2).position(position);
        return this;
    }

    public Msg put(ByteBuffer src) {
        ByteBuffer dup2 = this.buf.duplicate();
        dup2.position(this.writeIndex);
        this.writeIndex += Math.min(dup2.remaining(), src.remaining());
        dup2.put(src);
        return this;
    }

    public int getBytes(int index2, byte[] dst, int off, int len2) {
        int count2 = Math.min(len2, this.size - index2);
        if (this.data == null) {
            ByteBuffer dup2 = this.buf.duplicate();
            dup2.position(index2);
            dup2.put(dst, off, count2);
        } else {
            System.arraycopy(this.data, index2, dst, off, count2);
        }
        return count2;
    }

    public int getBytes(int index2, ByteBuffer bb, int len2) {
        ByteBuffer dup2 = this.buf.duplicate();
        dup2.position(index2);
        int count2 = Math.min(bb.remaining(), dup2.remaining());
        count2 = Math.min(count2, len2);
        bb.put(dup2);
        return count2;
    }

    public String toString() {
        return String.format("#zmq.Msg{type=%s, size=%s, flags=%s}", new Object[]{this.type, this.size, this.flags});
    }

    protected final int getWriteIndex() {
        return this.writeIndex;
    }

    protected final void setWriteIndex(int writeIndex) {
        this.writeIndex = writeIndex;
    }

    public long getLong(int offset) {
        return Wire.getUInt64(this.buf, offset);
    }

    public int getInt(int offset) {
        return Wire.getUInt32(this.buf, offset);
    }

    public void transfer(ByteBuffer destination, int srcOffset, int srcLength) {
        int position = this.buf.position();
        int limit2 = this.buf.limit();
        this.buf.limit(srcOffset + srcLength).position(srcOffset);
        destination.put(this.buf);
        this.buf.limit(limit2).position(position);
    }

    static enum Type {
        DATA,
        DELIMITER;

    }

    public static final class Builder
    extends Msg {
        private final ByteArrayOutputStream out = new ByteArrayOutputStream();

        @Override
        public int size() {
            return this.out.size();
        }

        @Override
        protected Msg put(int index2, byte b2) {
            this.out.write(b2);
            return this;
        }

        @Override
        public Msg put(byte[] src, int off, int len2) {
            if (src == null) {
                return this;
            }
            this.out.write(src, off, len2);
            this.setWriteIndex(this.getWriteIndex() + len2);
            return this;
        }

        @Override
        public Msg put(ByteBuffer src, int off, int len2) {
            if (src == null) {
                return this;
            }
            for (int idx = off; idx < off + len2; ++idx) {
                this.out.write(src.get(idx));
            }
            this.setWriteIndex(this.getWriteIndex() + len2);
            return this;
        }

        @Override
        public void setFlags(int flags) {
            super.setFlags(flags);
        }

        public Msg build() {
            return new Msg(this, this.out);
        }
    }
}

