/*
 * Decompiled with CFR 0.152.
 */
package zmq.io.coder.v2;

import java.nio.ByteBuffer;
import zmq.Msg;
import zmq.io.coder.Decoder;
import zmq.io.coder.IDecoder;
import zmq.msg.MsgAllocator;
import zmq.util.Errno;
import zmq.util.Wire;

public class V2Decoder
extends Decoder {
    private final ByteBuffer tmpbuf = ByteBuffer.allocate(8);
    private int msgFlags;

    public V2Decoder(Errno errno, int bufsize, long maxmsgsize, MsgAllocator allocator) {
        super(errno, bufsize, maxmsgsize, allocator);
        this.tmpbuf.limit(1);
        this.nextStep(this.tmpbuf, this.flagsReady);
    }

    @Override
    protected Msg allocate(int size2) {
        Msg msg = super.allocate(size2);
        msg.setFlags(this.msgFlags);
        return msg;
    }

    @Override
    protected IDecoder.Step.Result oneByteSizeReady() {
        int size2 = this.tmpbuf.get(0) & 0xFF;
        IDecoder.Step.Result rc = this.sizeReady(size2);
        if (rc != IDecoder.Step.Result.ERROR) {
            this.nextStep(this.inProgress, this.messageReady);
        }
        return rc;
    }

    @Override
    protected IDecoder.Step.Result eightByteSizeReady() {
        this.tmpbuf.position(0);
        this.tmpbuf.limit(8);
        long size2 = Wire.getUInt64(this.tmpbuf, 0);
        IDecoder.Step.Result rc = this.sizeReady(size2);
        if (rc != IDecoder.Step.Result.ERROR) {
            this.nextStep(this.inProgress, this.messageReady);
        }
        return rc;
    }

    @Override
    protected IDecoder.Step.Result flagsReady() {
        this.msgFlags = 0;
        int first2 = this.tmpbuf.get(0) & 0xFF;
        if ((first2 & 1) > 0) {
            this.msgFlags |= 1;
        }
        if ((first2 & 4) > 0) {
            this.msgFlags |= 2;
        }
        this.tmpbuf.position(0);
        if ((first2 & 2) > 0) {
            this.tmpbuf.limit(8);
            this.nextStep(this.tmpbuf, this.eightByteSizeReady);
        } else {
            this.tmpbuf.limit(1);
            this.nextStep(this.tmpbuf, this.oneByteSizeReady);
        }
        return IDecoder.Step.Result.MORE_DATA;
    }

    @Override
    protected IDecoder.Step.Result messageReady() {
        this.tmpbuf.position(0);
        this.tmpbuf.limit(1);
        this.nextStep(this.tmpbuf, this.flagsReady);
        return IDecoder.Step.Result.DECODED;
    }
}

