/*
 * Decompiled with CFR 0.152.
 */
package zmq.socket.pubsub;

import java.nio.ByteBuffer;
import zmq.Msg;
import zmq.pipe.Pipe;
import zmq.util.Utils;

class Trie {
    private int refcnt = 0;
    private byte min = 0;
    private int count = 0;
    private int liveNodes = 0;
    Trie[] next = null;

    public boolean add(Msg msg, int start2, int size2) {
        if (size2 == 0) {
            ++this.refcnt;
            return this.refcnt == 1;
        }
        byte c = msg.get(start2);
        if (c < this.min || c >= this.min + this.count) {
            if (this.count == 0) {
                this.min = c;
                this.count = 1;
                this.next = null;
            } else if (this.count == 1) {
                byte oldc = this.min;
                Trie oldp = this.next[0];
                this.count = (this.min < c ? c - this.min : this.min - c) + 1;
                this.next = new Trie[this.count];
                this.min = (byte)Math.min(this.min, c);
                this.next[oldc - this.min] = oldp;
            } else if (this.min < c) {
                this.count = c - this.min + 1;
                this.next = this.realloc(this.next, this.count, true);
            } else {
                this.count = this.min + this.count - c;
                this.next = this.realloc(this.next, this.count, false);
                this.min = c;
            }
        }
        if (this.count == 1) {
            if (this.next == null) {
                this.next = new Trie[1];
                this.next[0] = new Trie();
                ++this.liveNodes;
                assert (this.liveNodes == 1);
            }
            return this.next[0].add(msg, start2 + 1, size2 - 1);
        }
        if (this.next[c - this.min] == null) {
            this.next[c - this.min] = new Trie();
            ++this.liveNodes;
            assert (this.liveNodes > 1);
        }
        return this.next[c - this.min].add(msg, start2 + 1, size2 - 1);
    }

    private Trie[] realloc(Trie[] table, int size2, boolean ended) {
        return Utils.realloc(Trie.class, table, size2, ended);
    }

    public boolean rm(Msg msg, int start2, int size2) {
        Trie nextNode;
        if (size2 == 0) {
            if (this.refcnt == 0) {
                return false;
            }
            --this.refcnt;
            return this.refcnt == 0;
        }
        byte c = msg.get(start2);
        if (this.count == 0 || c < this.min || c >= this.min + this.count) {
            return false;
        }
        Trie trie = nextNode = this.count == 1 ? this.next[0] : this.next[c - this.min];
        if (nextNode == null) {
            return false;
        }
        boolean ret = nextNode.rm(msg, start2 + 1, size2 - 1);
        if (nextNode.isRedundant()) {
            assert (this.count > 0);
            if (this.count == 1) {
                this.next = null;
                this.count = 0;
                --this.liveNodes;
                assert (this.liveNodes == 0);
            } else {
                this.next[c - this.min] = null;
                assert (this.liveNodes > 1);
                --this.liveNodes;
                if (this.liveNodes == 1) {
                    Trie node4 = null;
                    if (c == this.min) {
                        node4 = this.next[this.count - 1];
                        this.min = (byte)(this.min + (this.count - 1));
                    } else if (c == this.min + this.count - 1) {
                        node4 = this.next[0];
                    }
                    assert (node4 != null);
                    this.next = new Trie[]{node4};
                    this.count = 1;
                } else if (c == this.min) {
                    byte newMin = this.min;
                    for (int i = 1; i < this.count; ++i) {
                        if (this.next[i] == null) continue;
                        newMin = (byte)(i + this.min);
                        break;
                    }
                    assert (newMin != this.min);
                    assert (newMin > this.min);
                    assert (this.count > newMin - this.min);
                    this.count -= newMin - this.min;
                    this.next = this.realloc(this.next, this.count, true);
                    this.min = newMin;
                } else if (c == this.min + this.count - 1) {
                    int newCount = this.count;
                    for (int i = 1; i < this.count; ++i) {
                        if (this.next[this.count - 1 - i] == null) continue;
                        newCount = this.count - i;
                        break;
                    }
                    assert (newCount != this.count);
                    this.count = newCount;
                    this.next = this.realloc(this.next, this.count, false);
                }
            }
        }
        return ret;
    }

    public boolean check(ByteBuffer data) {
        int size2 = data.limit();
        Trie current = this;
        int start2 = 0;
        while (current.refcnt <= 0) {
            if (size2 == 0) {
                return false;
            }
            byte c = data.get(start2);
            if (c < current.min || c >= current.min + current.count) {
                return false;
            }
            if (current.count == 1) {
                current = current.next[0];
            } else {
                current = current.next[c - current.min];
                if (current == null) {
                    return false;
                }
            }
            ++start2;
            --size2;
        }
        return true;
    }

    public void apply(ITrieHandler func, Pipe arg) {
        this.applyHelper(null, 0, 0, func, arg);
    }

    private void applyHelper(byte[] buff, int buffsize, int maxBuffsize, ITrieHandler func, Pipe pipe) {
        if (this.refcnt > 0) {
            func.added(buff, buffsize, pipe);
        }
        if (buffsize >= maxBuffsize) {
            maxBuffsize = buffsize + 256;
            buff = Utils.realloc(buff, maxBuffsize);
            assert (buff != null);
        }
        if (this.count == 0) {
            return;
        }
        if (this.count == 1) {
            buff[buffsize] = this.min;
            this.next[0].applyHelper(buff, ++buffsize, maxBuffsize, func, pipe);
            return;
        }
        for (int c = 0; c != this.count; ++c) {
            buff[buffsize] = (byte)(this.min + c);
            if (this.next[c] == null) continue;
            this.next[c].applyHelper(buff, buffsize + 1, maxBuffsize, func, pipe);
        }
    }

    private boolean isRedundant() {
        return this.refcnt == 0 && this.liveNodes == 0;
    }

    public static interface ITrieHandler {
        public void added(byte[] var1, int var2, Pipe var3);
    }
}

