/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.UUID;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.util.RepositoryLockMechanism;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CooperativeFileLock
implements RepositoryLockMechanism {
    private static final Logger LOG = LoggerFactory.getLogger(CooperativeFileLock.class);
    private static final String MAGIC = "CooperativeFileLock";
    private static final String FILE_NAME = "lock.properties";
    private static final int MAX_FILE_RETRY = 16;
    private static final int SLEEP_GAP = 25;
    private static final int TIME_GRANULARITY = 2000;
    private static final int LOCK_SLEEP = 1000;
    private String fileName;
    private long lastWrite;
    private Properties properties;
    private boolean locked;
    private volatile boolean stop;
    private Thread watchdog;

    @Override
    public void init(String path) {
        this.fileName = path + File.separatorChar + FILE_NAME;
    }

    @Override
    public synchronized void acquire() throws RepositoryException {
        if (this.locked) {
            throw new RepositoryException("Already locked " + this.fileName);
        }
        this.stop = false;
        this.lockFile();
        this.locked = true;
    }

    @Override
    public synchronized void release() {
        if (!this.locked) {
            return;
        }
        try {
            this.stop = true;
            if (this.fileName != null && this.load().equals(this.properties)) {
                CooperativeFileLock.delete(this.fileName);
            }
        }
        catch (Exception e) {
            LOG.warn("Error unlocking " + this.fileName, e);
        }
        finally {
            this.locked = false;
        }
        try {
            if (this.watchdog != null) {
                this.watchdog.interrupt();
            }
        }
        catch (Exception e) {
            LOG.debug("Error stopping watchdog " + this.fileName, e);
        }
    }

    private void save() throws RepositoryException {
        try {
            try (FileOutputStream out = new FileOutputStream(this.fileName);){
                this.properties.store(out, MAGIC);
            }
            this.lastWrite = new File(this.fileName).lastModified();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Save " + String.valueOf(this.properties));
            }
        }
        catch (IOException e) {
            throw this.getException(e);
        }
    }

    private Properties load() throws RepositoryException {
        try {
            Properties p2 = new Properties();
            try (FileInputStream in = new FileInputStream(this.fileName);){
                p2.load(in);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Load " + String.valueOf(p2));
            }
            return p2;
        }
        catch (IOException e) {
            throw this.getException(e);
        }
    }

    private void waitUntilOld() throws RepositoryException {
        for (int i = 0; i < 80; ++i) {
            File f = new File(this.fileName);
            long last = f.lastModified();
            long dist = System.currentTimeMillis() - last;
            if (dist < -2000L) {
                try {
                    Thread.sleep(2000L);
                }
                catch (Exception e) {
                    LOG.debug("Sleep", e);
                }
                return;
            }
            if (dist > 2000L) {
                return;
            }
            try {
                Thread.sleep(25L);
                continue;
            }
            catch (Exception e) {
                LOG.debug("Sleep", e);
            }
        }
        throw this.error("Lock file recently modified");
    }

    private void lockFile() throws RepositoryException {
        this.properties = new Properties();
        UUID uuid = UUID.randomUUID();
        this.properties.setProperty("id", uuid.toString());
        if (!CooperativeFileLock.createNewFile(this.fileName)) {
            this.waitUntilOld();
            this.save();
            for (int i = 0; i < 8; ++i) {
                this.sleep(250);
                if (this.load().equals(this.properties)) continue;
                throw this.error("Locked by another process");
            }
            CooperativeFileLock.delete(this.fileName);
            if (!CooperativeFileLock.createNewFile(this.fileName)) {
                throw this.error("Another process was faster");
            }
        }
        this.save();
        this.sleep(25);
        if (!this.load().equals(this.properties)) {
            this.stop = true;
            throw this.error("Concurrent update");
        }
        this.watchdog = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (!CooperativeFileLock.this.stop) {
                        try {
                            File f = new File(CooperativeFileLock.this.fileName);
                            if (!f.exists() || f.lastModified() != CooperativeFileLock.this.lastWrite) {
                                CooperativeFileLock.this.save();
                            }
                            Thread.sleep(1000L);
                        }
                        catch (OutOfMemoryError f) {
                        }
                        catch (InterruptedException f) {
                        }
                        catch (NullPointerException f) {
                        }
                        catch (Exception e) {
                            LOG.debug("Watchdog", e);
                        }
                    }
                }
                catch (Exception e) {
                    LOG.debug("Watchdog", e);
                }
                LOG.debug("Watchdog end");
            }
        });
        this.watchdog.setName("CooperativeFileLock Watchdog " + this.fileName);
        this.watchdog.setDaemon(true);
        this.watchdog.setPriority(9);
        this.watchdog.start();
    }

    private RepositoryException getException(Throwable t) {
        return new RepositoryException("Internal error in file lock " + this.fileName, t);
    }

    private RepositoryException error(String reason) {
        return new RepositoryException("Error locking " + this.fileName + ", reason: " + reason);
    }

    private void sleep(int time) throws RepositoryException {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException e) {
            throw this.getException(e);
        }
    }

    private static boolean createNewFile(String fileName) {
        File file = new File(fileName);
        for (int i = 0; i < 16; ++i) {
            try {
                return file.createNewFile();
            }
            catch (IOException e) {
                CooperativeFileLock.wait(i);
                continue;
            }
        }
        return false;
    }

    private static void delete(String fileName) throws RepositoryException {
        File file = new File(fileName);
        if (file.exists()) {
            for (int i = 0; i < 16; ++i) {
                boolean ok;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Deleting " + fileName);
                }
                if (ok = file.delete()) {
                    return;
                }
                CooperativeFileLock.wait(i);
            }
            throw new RepositoryException("Could not delete file " + fileName);
        }
    }

    private static void wait(int i) {
        if (i > 8) {
            System.gc();
        }
        try {
            long sleep = Math.min(256, i * i);
            Thread.sleep(sleep);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

