/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc;

import java.net.URI;
import java.util.Optional;
import org.netpreserve.jwarc.MessageBody;
import org.netpreserve.jwarc.MessageHeaders;
import org.netpreserve.jwarc.MessageVersion;
import org.netpreserve.jwarc.WarcRecord;
import org.netpreserve.jwarc.WarcTargetRecord;

public class WarcContinuation
extends WarcTargetRecord {
    WarcContinuation(MessageVersion version, MessageHeaders headers, MessageBody body) {
        super(version, headers, body);
    }

    public URI segmentOriginId() {
        return this.headers().sole("WARC-Segment-Origin-ID").map(WarcRecord::parseRecordID).get();
    }

    public Optional<Long> segmentTotalLength() {
        return this.headers().sole("WARC-Segment-Total-Length").map(Long::valueOf);
    }

    public static class Builder
    extends WarcTargetRecord.Builder<WarcContinuation, Builder> {
        public Builder() {
            super("continuation");
        }

        public Builder segmentOriginId(URI recordId) {
            return (Builder)this.setHeader("WARC-Segment-Origin-Id", WarcRecord.formatId(recordId));
        }

        public Builder segmentTotalLength(long segmentTotalLength) {
            return (Builder)this.setHeader("WARC-Segment-Total-Length", Long.toString(segmentTotalLength));
        }

        @Override
        public WarcContinuation build() {
            return this.build(WarcContinuation::new);
        }
    }
}

