/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.crypto;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Optional;
import javax.inject.Inject;
import nl.altindag.ssl.exception.CertificateParseException;
import nl.altindag.ssl.util.KeyStoreUtils;
import nl.altindag.ssl.util.PemUtils;
import org.apache.commons.io.IOUtils;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.jmap.draft.JMAPDraftConfiguration;
import org.apache.james.jmap.draft.crypto.AsymmetricKeys;
import org.apache.james.jwt.PublicKeyReader;

public class SecurityKeyLoader {
    private static final String ALIAS = "james";
    private final FileSystem fileSystem;
    private final JMAPDraftConfiguration jmapDraftConfiguration;

    @Inject
    @VisibleForTesting
    SecurityKeyLoader(FileSystem fileSystem, JMAPDraftConfiguration jmapDraftConfiguration) {
        this.fileSystem = fileSystem;
        this.jmapDraftConfiguration = jmapDraftConfiguration;
    }

    public AsymmetricKeys load() throws Exception {
        Preconditions.checkState((boolean)this.jmapDraftConfiguration.isEnabled(), (Object)"JMAP is not enabled");
        if (this.jmapDraftConfiguration.getKeystore().isPresent()) {
            return this.loadFromKeystore();
        }
        return this.loadFromPEM();
    }

    private AsymmetricKeys loadFromKeystore() throws Exception {
        Preconditions.checkState((boolean)this.jmapDraftConfiguration.getKeystore().isPresent());
        Preconditions.checkState((boolean)this.jmapDraftConfiguration.getSecret().isPresent());
        char[] secret = this.jmapDraftConfiguration.getSecret().get().toCharArray();
        KeyStore keystore = KeyStoreUtils.loadKeyStore((InputStream)this.fileSystem.getResource(this.jmapDraftConfiguration.getKeystore().get()), (char[])secret);
        Certificate aliasCertificate = Optional.ofNullable(keystore.getCertificate(ALIAS)).orElseThrow(() -> new KeyStoreException("Alias 'james' keystore can't be found"));
        PublicKey publicKey = aliasCertificate.getPublicKey();
        Key key = keystore.getKey(ALIAS, secret);
        if (!(key instanceof PrivateKey)) {
            throw new KeyStoreException("Provided key is not a PrivateKey");
        }
        return new AsymmetricKeys((PrivateKey)key, publicKey);
    }

    private AsymmetricKeys loadFromPEM() throws Exception {
        Preconditions.checkState((boolean)this.jmapDraftConfiguration.getCertificates().isPresent());
        Preconditions.checkState((boolean)this.jmapDraftConfiguration.getPrivateKey().isPresent());
        PrivateKey privateKey = PemUtils.loadPrivateKey((InputStream)this.fileSystem.getResource(this.jmapDraftConfiguration.getPrivateKey().get()), (char[])this.jmapDraftConfiguration.getSecret().map(String::toCharArray).orElse(null));
        return new AsymmetricKeys(privateKey, this.loadPublicKey());
    }

    private PublicKey loadPublicKey() throws IOException {
        try {
            X509Certificate certificate = (X509Certificate)PemUtils.loadCertificate((InputStream[])new InputStream[]{this.fileSystem.getResource(this.jmapDraftConfiguration.getCertificates().get())}).get(0);
            return certificate.getPublicKey();
        }
        catch (CertificateParseException e) {
            String publicKeyAsString = IOUtils.toString((InputStream)this.fileSystem.getResource(this.jmapDraftConfiguration.getCertificates().get()), (Charset)StandardCharsets.US_ASCII);
            return (PublicKey)new PublicKeyReader().fromPEM(publicKeyAsString).orElseThrow(() -> new IllegalArgumentException("Key must either be a valid certificate or a public key"));
        }
    }
}

