/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.crypto;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import javax.inject.Inject;
import org.apache.james.jmap.draft.api.SimpleTokenFactory;
import org.apache.james.jmap.draft.crypto.SignatureHandler;
import org.apache.james.jmap.draft.model.AttachmentAccessToken;
import org.apache.james.jmap.draft.model.ContinuationToken;
import org.apache.james.util.date.ZonedDateTimeProvider;

public class SignedTokenFactory
implements SimpleTokenFactory {
    private final SignatureHandler signatureHandler;
    private final ZonedDateTimeProvider zonedDateTimeProvider;

    @Inject
    public SignedTokenFactory(SignatureHandler signatureHandler, ZonedDateTimeProvider zonedDateTimeProvider) {
        this.signatureHandler = signatureHandler;
        this.zonedDateTimeProvider = zonedDateTimeProvider;
    }

    @Override
    public ContinuationToken generateContinuationToken(String username) {
        Preconditions.checkNotNull((Object)username);
        ZonedDateTime expirationTime = ((ZonedDateTime)this.zonedDateTimeProvider.get()).plusMinutes(15L);
        return new ContinuationToken(username, expirationTime, this.signatureHandler.sign(Joiner.on((String)"_").join((Object)username, (Object)DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(expirationTime), new Object[0])));
    }

    @Override
    public AttachmentAccessToken generateAttachmentAccessToken(String username, String blobId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)blobId) ? 1 : 0) != 0);
        ZonedDateTime expirationTime = ((ZonedDateTime)this.zonedDateTimeProvider.get()).plusMinutes(5L);
        return AttachmentAccessToken.builder().username(username).blobId(blobId).expirationDate(expirationTime).signature(this.signatureHandler.sign(Joiner.on((char)'_').join((Object)blobId, (Object)username, new Object[]{DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(expirationTime)}))).build();
    }
}

