/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft;

import java.util.Arrays;
import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.events.EventBus;
import org.apache.james.events.EventListener;
import org.apache.james.jmap.JMAPServer;
import org.apache.james.jmap.api.change.EmailChange;
import org.apache.james.jmap.api.change.EmailChangeRepository;
import org.apache.james.jmap.api.change.MailboxChangeRepository;
import org.apache.james.jmap.api.change.State;
import org.apache.james.jmap.api.model.AccountId;
import org.apache.james.jmap.api.projections.MessageFastViewProjection;
import org.apache.james.jmap.draft.utils.AccountIdUtil;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageIdManager;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.util.Port;
import org.apache.james.utils.GuiceProbe;
import org.apache.james.vacation.api.Vacation;
import org.apache.james.vacation.api.VacationPatch;
import org.apache.james.vacation.api.VacationService;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class JmapGuiceProbe
implements GuiceProbe {
    private final VacationService vacationService;
    private final MailboxChangeRepository mailboxChangeRepository;
    private final EmailChangeRepository emailChangeRepository;
    private final JMAPServer jmapServer;
    private final MessageIdManager messageIdManager;
    private final MailboxManager mailboxManager;
    private final EventBus eventBus;
    private final MessageFastViewProjection messageFastViewProjection;

    @Inject
    private JmapGuiceProbe(VacationService vacationService, MailboxChangeRepository mailboxChangeRepository, EmailChangeRepository emailChangeRepository, JMAPServer jmapServer, MessageIdManager messageIdManager, MailboxManager mailboxManager, EventBus eventBus, MessageFastViewProjection messageFastViewProjection) {
        this.vacationService = vacationService;
        this.mailboxChangeRepository = mailboxChangeRepository;
        this.emailChangeRepository = emailChangeRepository;
        this.jmapServer = jmapServer;
        this.messageIdManager = messageIdManager;
        this.mailboxManager = mailboxManager;
        this.eventBus = eventBus;
        this.messageFastViewProjection = messageFastViewProjection;
    }

    public Port getJmapPort() {
        return this.jmapServer.getPort();
    }

    public void addEventListener(EventListener.GroupEventListener listener) {
        this.eventBus.register(listener);
    }

    public void modifyVacation(AccountId accountId, VacationPatch vacationPatch) {
        this.vacationService.modifyVacation(AccountIdUtil.toVacationAccountId((AccountId)accountId), vacationPatch).block();
    }

    public Vacation retrieveVacation(AccountId accountId) {
        return (Vacation)this.vacationService.retrieveVacation(AccountIdUtil.toVacationAccountId((AccountId)accountId)).block();
    }

    public void setInMailboxes(MessageId messageId, Username username, MailboxId ... mailboxIds) throws MailboxException {
        MailboxSession mailboxSession = this.mailboxManager.createSystemSession(username);
        this.messageIdManager.setInMailboxes(messageId, Arrays.asList(mailboxIds), mailboxSession);
    }

    public void clearMessageFastViewProjection() {
        Mono.from((Publisher)this.messageFastViewProjection.clear()).block();
    }

    public void saveEmailChange(EmailChange change) {
        this.emailChangeRepository.save(change).block();
    }

    public State getLatestMailboxState(AccountId accountId) {
        return (State)this.mailboxChangeRepository.getLatestState(accountId).block();
    }

    public State getLatestMailboxStateWithDelegation(AccountId accountId) {
        return (State)this.mailboxChangeRepository.getLatestStateWithDelegation(accountId).block();
    }

    public State getLatestEmailState(AccountId accountId) {
        return (State)this.emailChangeRepository.getLatestState(accountId).block();
    }

    public State getLatestEmailStateWithDelegation(AccountId accountId) {
        return (State)this.emailChangeRepository.getLatestStateWithDelegation(accountId).block();
    }
}

