/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.james.mailbox.model.Content;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public final class Header
implements Content {
    private final String name;
    private final String value;
    private final long size;

    public Header(String name, String value) {
        this.name = name;
        this.value = value;
        this.size = name.length() + value.length() + 2;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public long size() {
        return this.size;
    }

    public String toString() {
        return "[HEADER " + this.name + ": " + this.value + "]";
    }

    @Override
    public InputStream getInputStream() {
        return new ByteArrayInputStream((this.name + ": " + this.value).getBytes(StandardCharsets.US_ASCII));
    }

    @Override
    public Publisher<ByteBuffer> reactiveBytes() {
        return Flux.just((Object)(this.name + ": " + this.value).getBytes(StandardCharsets.US_ASCII)).map(ByteBuffer::wrap);
    }
}

