/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs.v2.syntax;

import com.unboundid.ldap.sdk.unboundidds.logs.v2.syntax.LogFieldSyntax;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.syntax.LogSyntaxException;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.syntax.LogSyntaxMessages;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.syntax.RedactedValueException;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.syntax.TokenizedValueException;
import com.unboundid.util.ByteStringBuffer;
import com.unboundid.util.Debug;
import com.unboundid.util.NotNull;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONBuffer;
import java.text.DecimalFormat;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class FloatingPointLogFieldSyntax
extends LogFieldSyntax<Double> {
    @NotNull
    public static final String SYNTAX_NAME = "floating-point";
    @NotNull
    private static final String REDACTED_FLOATING_POINT_STRING = "-999999.999999";
    @NotNull
    private static final FloatingPointLogFieldSyntax INSTANCE = new FloatingPointLogFieldSyntax();
    @NotNull
    private final ThreadLocal<DecimalFormat> threadLocalFormatters = new ThreadLocal();

    private FloatingPointLogFieldSyntax() {
        super(100);
    }

    @NotNull
    public static FloatingPointLogFieldSyntax getInstance() {
        return INSTANCE;
    }

    @Override
    @NotNull
    public String getSyntaxName() {
        return SYNTAX_NAME;
    }

    @Override
    public void valueToSanitizedString(float value, @NotNull ByteStringBuffer buffer) {
        buffer.append(this.getDecimalFormatter().format(value));
    }

    @Override
    public void valueToSanitizedString(double value, @NotNull ByteStringBuffer buffer) {
        buffer.append(this.getDecimalFormatter().format(value));
    }

    @Override
    public void valueToSanitizedString(@NotNull Double value, @NotNull ByteStringBuffer buffer) {
        buffer.append(this.getDecimalFormatter().format(value));
    }

    @NotNull
    private DecimalFormat getDecimalFormatter() {
        DecimalFormat formatter = this.threadLocalFormatters.get();
        if (formatter == null) {
            formatter = new DecimalFormat("0.000");
            this.threadLocalFormatters.set(formatter);
        }
        return formatter;
    }

    @Override
    public void logSanitizedFieldToTextFormattedLog(@NotNull String fieldName, @NotNull Double fieldValue, @NotNull ByteStringBuffer buffer) {
        buffer.append(' ');
        buffer.append(fieldName);
        buffer.append('=');
        buffer.append(this.getDecimalFormatter().format(fieldValue));
    }

    @Override
    public void logSanitizedFieldToJSONFormattedLog(@NotNull String fieldName, @NotNull Double fieldValue, @NotNull JSONBuffer buffer) {
        buffer.appendNumber(fieldName, this.getDecimalFormatter().format(fieldValue));
    }

    @Override
    public void logSanitizedValueToJSONFormattedLog(@NotNull Double value, @NotNull JSONBuffer buffer) {
        buffer.appendNumber(this.getDecimalFormatter().format(value));
    }

    @Override
    @NotNull
    public Double parseValue(@NotNull String valueString) throws RedactedValueException, TokenizedValueException, LogSyntaxException {
        try {
            return Double.parseDouble(valueString);
        }
        catch (Exception e) {
            Debug.debugException(e);
            if (this.valueStringIncludesRedactedComponent(valueString)) {
                throw new RedactedValueException(LogSyntaxMessages.ERR_FP_LOG_SYNTAX_CANNOT_PARSE_REDACTED.get(), e);
            }
            if (this.valueStringIncludesTokenizedComponent(valueString)) {
                throw new TokenizedValueException(LogSyntaxMessages.ERR_FP_LOG_SYNTAX_CANNOT_PARSE_TOKENIZED.get(), e);
            }
            throw new LogSyntaxException(LogSyntaxMessages.ERR_FP_LOG_SYNTAX_CANNOT_PARSE.get(), e);
        }
    }

    @Override
    public boolean valueStringIsCompletelyRedacted(@NotNull String valueString) {
        return valueString.equals("{REDACTED}") || valueString.equals(REDACTED_FLOATING_POINT_STRING);
    }

    @Override
    public boolean completelyRedactedValueConformsToSyntax() {
        return true;
    }

    @Override
    public void redactEntireValue(@NotNull ByteStringBuffer buffer) {
        buffer.append(REDACTED_FLOATING_POINT_STRING);
    }

    @Override
    public void logCompletelyRedactedFieldToTextFormattedLog(@NotNull String fieldName, @NotNull ByteStringBuffer buffer) {
        buffer.append(' ');
        buffer.append(fieldName);
        buffer.append('=');
        buffer.append(REDACTED_FLOATING_POINT_STRING);
    }

    @Override
    public void logCompletelyRedactedFieldToJSONFormattedLog(@NotNull String fieldName, @NotNull JSONBuffer buffer) {
        buffer.appendNumber(fieldName, REDACTED_FLOATING_POINT_STRING);
    }

    @Override
    public void logCompletelyRedactedValueToJSONFormattedLog(@NotNull JSONBuffer buffer) {
        buffer.appendNumber(REDACTED_FLOATING_POINT_STRING);
    }

    @Override
    public boolean supportsRedactedComponents() {
        return false;
    }

    @Override
    public boolean valueStringIncludesRedactedComponent(@NotNull String valueString) {
        return this.valueStringIsCompletelyRedacted(valueString);
    }

    @Override
    public boolean valueWithRedactedComponentsConformsToSyntax() {
        return true;
    }

    @Override
    public void logRedactedComponentsFieldToTextFormattedLog(@NotNull String fieldName, @NotNull Double fieldValue, @NotNull ByteStringBuffer buffer) {
        this.logCompletelyRedactedFieldToTextFormattedLog(fieldName, buffer);
    }

    @Override
    public void logRedactedComponentsFieldToJSONFormattedLog(@NotNull String fieldName, @NotNull Double fieldValue, @NotNull JSONBuffer buffer) {
        this.logCompletelyRedactedFieldToJSONFormattedLog(fieldName, buffer);
    }

    @Override
    public void logRedactedComponentsValueToJSONFormattedLog(@NotNull Double value, @NotNull JSONBuffer buffer) {
        this.logCompletelyRedactedValueToJSONFormattedLog(buffer);
    }

    @Override
    public boolean valueStringIsCompletelyTokenized(@NotNull String valueString) {
        if (super.valueStringIsCompletelyTokenized(valueString)) {
            return true;
        }
        return valueString.length() == 14 && valueString.startsWith("-999999.") && !valueString.equals(REDACTED_FLOATING_POINT_STRING);
    }

    @Override
    public boolean completelyTokenizedValueConformsToSyntax() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tokenizeEntireValue(@NotNull Double value, @NotNull byte[] pepper, @NotNull ByteStringBuffer buffer) {
        byte[] tokenDigest;
        long valueBitsLong = Double.doubleToLongBits(value);
        byte[] valueBytes = new byte[]{(byte)(valueBitsLong >> 56 & 0xFFL), (byte)(valueBitsLong >> 48 & 0xFFL), (byte)(valueBitsLong >> 40 & 0xFFL), (byte)(valueBitsLong >> 32 & 0xFFL), (byte)(valueBitsLong >> 24 & 0xFFL), (byte)(valueBitsLong >> 16 & 0xFFL), (byte)(valueBitsLong >> 8 & 0xFFL), (byte)(valueBitsLong & 0xFFL)};
        ByteStringBuffer tempBuffer = this.getTemporaryBuffer();
        try {
            tempBuffer.append(valueBytes);
            tempBuffer.append(pepper);
            tokenDigest = this.sha256(tempBuffer);
        }
        finally {
            this.releaseTemporaryBuffer(tempBuffer);
        }
        int fractionalDigitsInt = (tokenDigest[0] & 0x7F | 0x40) << 24 | (tokenDigest[1] & 0xFF) << 16 | (tokenDigest[2] & 0xFF) << 8 | tokenDigest[3] & 0xFF;
        String fractionalDigits = String.valueOf(fractionalDigitsInt).substring(4);
        if (fractionalDigits.equals("999999")) {
            fractionalDigits = "000000";
        }
        buffer.append("-999999.");
        buffer.append(fractionalDigits);
    }

    @Override
    public void logCompletelyTokenizedFieldToTextFormattedLog(@NotNull String fieldName, @NotNull Double fieldValue, @NotNull byte[] pepper, @NotNull ByteStringBuffer buffer) {
        buffer.append(' ');
        buffer.append(fieldName);
        buffer.append('=');
        this.tokenizeEntireValue(fieldValue, pepper, buffer);
    }

    @Override
    public void logCompletelyTokenizedFieldToJSONFormattedLog(@NotNull String fieldName, @NotNull Double fieldValue, @NotNull byte[] pepper, @NotNull JSONBuffer buffer) {
        buffer.appendNumber(fieldName, this.tokenizeEntireValue(fieldValue, pepper));
    }

    @Override
    public void logCompletelyTokenizedValueToJSONFormattedLog(@NotNull Double value, @NotNull byte[] pepper, @NotNull JSONBuffer buffer) {
        buffer.appendNumber(this.tokenizeEntireValue(value, pepper));
    }

    @Override
    public boolean supportsTokenizedComponents() {
        return false;
    }

    @Override
    public boolean valueStringIncludesTokenizedComponent(@NotNull String valueString) {
        return this.valueStringIsCompletelyTokenized(valueString);
    }

    @Override
    public boolean valueWithTokenizedComponentsConformsToSyntax() {
        return true;
    }

    @Override
    public void logTokenizedComponentsFieldToTextFormattedLog(@NotNull String fieldName, @NotNull Double fieldValue, @NotNull byte[] pepper, @NotNull ByteStringBuffer buffer) {
        this.logCompletelyTokenizedFieldToTextFormattedLog(fieldName, fieldValue, pepper, buffer);
    }

    @Override
    public void logTokenizedComponentsFieldToJSONFormattedLog(@NotNull String fieldName, @NotNull Double fieldValue, @NotNull byte[] pepper, @NotNull JSONBuffer buffer) {
        this.logCompletelyTokenizedFieldToJSONFormattedLog(fieldName, fieldValue, pepper, buffer);
    }

    @Override
    public void logTokenizedComponentsValueToJSONFormattedLog(@NotNull Double value, @NotNull byte[] pepper, @NotNull JSONBuffer buffer) {
        this.logCompletelyTokenizedValueToJSONFormattedLog(value, pepper, buffer);
    }
}

