/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.web;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.jena.langtagx.LangTagX;

@Deprecated(forRemoval=true)
public class LangTag {
    public static final int idxLanguage = 0;
    public static final int idxScript = 1;
    public static final int idxRegion = 2;
    public static final int idxVariant = 3;
    public static final int idxExtension = 4;
    private static final int partsLength = 5;
    private static final String languageRE_1 = "(?:[a-zA-Z]{2,3}(?:-[a-zA-Z]{3}){0,3})";
    private static final String languageRE_2 = "[a-zA-Z]{4}";
    private static final String languageRE_3 = "[a-zA-Z]{5,8}";
    private static final String language = "(?:[a-zA-Z]{2,3}(?:-[a-zA-Z]{3}){0,3})|[a-zA-Z]{4}|[a-zA-Z]{5,8}";
    private static final String script = "[a-zA-Z]{4}";
    private static final String region = "[a-zA-Z]{2}|[0-9]{3}";
    private static final String variant = "[a-zA-Z0-9]{5,8}";
    private static final String extension1 = "(?:[a-zA-Z0-9]-[a-zA-Z0-9]{2,8})";
    private static final String extension = "(?:[a-zA-Z0-9]-[a-zA-Z0-9]{2,8})(?:-(?:[a-zA-Z0-9]-[a-zA-Z0-9]{2,8}))*";
    private static final String langtag = String.format("^(%s)(?:-(%s))?(?:-(%s))?(?:-(%s))?(?:-(%s))?$", "(?:[a-zA-Z]{2,3}(?:-[a-zA-Z]{3}){0,3})|[a-zA-Z]{4}|[a-zA-Z]{5,8}", "[a-zA-Z]{4}", "[a-zA-Z]{2}|[0-9]{3}", "[a-zA-Z0-9]{5,8}", "(?:[a-zA-Z0-9]-[a-zA-Z0-9]{2,8})(?:-(?:[a-zA-Z0-9]-[a-zA-Z0-9]{2,8}))*");
    private static final String privateuseRE = "^[xX](-[a-zA-Z0-9]{1,8})*$";
    private static final String grandfatheredRE = "i(?:-[a-zA-Z0-9]{2,8}){1,2}";
    private static Pattern pattern = Pattern.compile(langtag);
    private static Pattern patternPrivateuse = Pattern.compile("^[xX](-[a-zA-Z0-9]{1,8})*$");
    private static Pattern patternGrandfathered = Pattern.compile("i(?:-[a-zA-Z0-9]{2,8}){1,2}");

    private LangTag() {
    }

    @Deprecated(forRemoval=true)
    public static boolean check(String languageTag) {
        return LangTagX.checkLanguageTag(languageTag);
    }

    @Deprecated(forRemoval=true)
    public static String[] parse(String languageTag) {
        String[] parts = new String[5];
        String x = pattern.toString();
        Pattern.compile(languageRE_1);
        Matcher m = pattern.matcher(languageTag);
        if (!m.find()) {
            m = patternPrivateuse.matcher(languageTag);
            if (m.find()) {
                parts[4] = m.group(0);
                return parts;
            }
            m = patternGrandfathered.matcher(languageTag);
            if (m.find()) {
                parts[4] = m.group(0);
                return parts;
            }
            return null;
        }
        int gc = m.groupCount();
        for (int i = 0; i < gc; ++i) {
            parts[i] = m.group(i + 1);
        }
        parts[0] = LangTag.lowercase(parts[0]);
        parts[1] = LangTag.strcase(parts[1]);
        parts[2] = LangTag.strcase(parts[2]);
        parts[3] = LangTag.strcase(parts[3]);
        return parts;
    }

    private static String strcase(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() == 2) {
            return LangTag.uppercase(string);
        }
        if (string.length() == 4) {
            return LangTag.titlecase(string);
        }
        return LangTag.lowercase(string);
    }

    private static String lowercase(String string) {
        if (string == null) {
            return null;
        }
        return string.toLowerCase(Locale.ROOT);
    }

    private static String uppercase(String string) {
        if (string == null) {
            return null;
        }
        return string.toUpperCase(Locale.ROOT);
    }

    private static String titlecase(String string) {
        if (string == null) {
            return null;
        }
        char ch1 = string.charAt(0);
        ch1 = Character.toUpperCase(ch1);
        string = LangTag.lowercase(string.substring(1));
        return ch1 + string;
    }

    @Deprecated(forRemoval=true)
    public static String canonical(String langTagStr) {
        return LangTagX.formatLanguageTag(langTagStr);
    }
}

