/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.projection;

import java.util.EnumMap;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.sis.geometry.Envelope2D;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.measure.Latitude;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.internal.Resources;
import org.apache.sis.referencing.operation.matrix.Matrix2;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.projection.ConformalProjection;
import org.apache.sis.referencing.operation.projection.Initializer;
import org.apache.sis.referencing.operation.projection.NormalizedProjection;
import org.apache.sis.referencing.operation.projection.ProjectionException;
import org.apache.sis.referencing.operation.projection.ProjectionVariant;
import org.apache.sis.referencing.operation.provider.LambertConformal1SP;
import org.apache.sis.referencing.operation.provider.LambertConformal2SP;
import org.apache.sis.referencing.operation.provider.LambertConformalMichigan;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.apache.sis.referencing.operation.transform.DomainDefinition;
import org.apache.sis.referencing.util.Formulas;
import org.apache.sis.util.internal.DoubleDouble;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.FactoryException;

public class LambertConicConformal
extends ConformalProjection {
    private static final long serialVersionUID = 2067358524298002016L;
    static final DoubleDouble BELGE_A = DoubleDouble.of(-1.420431363598774E-4, -1.1777378450498224E-20);
    final double n;

    public LambertConicConformal(OperationMethod method, Parameters parameters) {
        this(LambertConicConformal.initializer(method, parameters));
    }

    private static Initializer initializer(OperationMethod method, Parameters parameters) {
        Variant variant = (Variant)LambertConicConformal.variant((OperationMethod)method, (ProjectionVariant[])Variant.values(), (ProjectionVariant)Variant.TWO_PARALLELS);
        EnumMap<NormalizedProjection.ParameterRole, ParameterDescriptor<Double>> roles = new EnumMap<NormalizedProjection.ParameterRole, ParameterDescriptor<Double>>(NormalizedProjection.ParameterRole.class);
        ParameterDescriptor<Double> scaleFactor = LambertConformal1SP.SCALE_FACTOR;
        NormalizedProjection.ParameterRole eastingDirection = NormalizedProjection.ParameterRole.FALSE_EASTING;
        switch (variant) {
            case WEST: {
                eastingDirection = NormalizedProjection.ParameterRole.FALSE_WESTING;
            }
            case ONE_PARALLEL: {
                roles.put(eastingDirection, LambertConformal1SP.FALSE_EASTING);
                roles.put(NormalizedProjection.ParameterRole.FALSE_NORTHING, LambertConformal1SP.FALSE_NORTHING);
                roles.put(NormalizedProjection.ParameterRole.CENTRAL_MERIDIAN, LambertConformal1SP.LONGITUDE_OF_ORIGIN);
                break;
            }
            case MICHIGAN: {
                scaleFactor = LambertConformalMichigan.SCALE_FACTOR;
            }
            case BELGIUM: 
            case TWO_PARALLELS: {
                roles.put(eastingDirection, LambertConformal2SP.EASTING_AT_FALSE_ORIGIN);
                roles.put(NormalizedProjection.ParameterRole.FALSE_NORTHING, LambertConformal2SP.NORTHING_AT_FALSE_ORIGIN);
                roles.put(NormalizedProjection.ParameterRole.CENTRAL_MERIDIAN, LambertConformal2SP.LONGITUDE_OF_FALSE_ORIGIN);
                break;
            }
            default: {
                throw new AssertionError(variant);
            }
        }
        roles.put(NormalizedProjection.ParameterRole.SCALE_FACTOR, scaleFactor);
        return new Initializer(method, parameters, roles, variant);
    }

    private LambertConicConformal(Initializer initializer) {
        super(initializer);
        Variant variant = (Variant)initializer.variant;
        double \u03c60 = initializer.getAndStore(variant.is1SP ? LambertConformal1SP.LATITUDE_OF_ORIGIN : LambertConformal2SP.LATITUDE_OF_FALSE_ORIGIN);
        double \u03c61 = initializer.getAndStore(LambertConformal2SP.STANDARD_PARALLEL_1, \u03c60);
        double \u03c62 = initializer.getAndStore(LambertConformal2SP.STANDARD_PARALLEL_2, \u03c61);
        if (Math.abs(\u03c61 + \u03c62) < 8.999280057595393E-8) {
            throw new IllegalArgumentException(Resources.format((short)31, new Latitude(\u03c61), new Latitude(\u03c62)));
        }
        boolean isNorth = MathFunctions.isPositive(\u03c60);
        if (isNorth) {
            \u03c60 = -\u03c60;
            \u03c61 = -\u03c61;
            \u03c62 = -\u03c62;
        }
        \u03c60 = Math.toRadians(\u03c60);
        \u03c61 = Math.toRadians(\u03c61);
        \u03c62 = Math.toRadians(\u03c62);
        double sin\u03c61 = Math.sin(\u03c61);
        double m1 = initializer.scaleAt\u03c6(sin\u03c61, Math.cos(\u03c61));
        double t1 = this.exp\u03a8(\u03c61, this.eccentricity * sin\u03c61);
        if (Math.abs(\u03c61 - \u03c62) >= 1.5706706731410455E-9) {
            double sin\u03c62 = Math.sin(\u03c62);
            double m2 = initializer.scaleAt\u03c6(sin\u03c62, Math.cos(\u03c62));
            double t2 = this.exp\u03a8(\u03c62, this.eccentricity * sin\u03c62);
            this.n = Math.log(m1 / m2) / Math.log(t1 / t2);
        } else {
            this.n = -sin\u03c61;
        }
        double F2 = m1 / (this.n * Math.pow(t1, this.n));
        if (!isNorth) {
            F2 = -F2;
        }
        Double rF = null;
        if (\u03c60 != Math.copySign(1.5707963267948966, -this.n)) {
            rF = F2 * Math.pow(this.exp\u03a8(\u03c60, this.eccentricity * Math.sin(\u03c60)), this.n);
        }
        double s\u03bb = this.n;
        Integer s\u03c6 = null;
        if (isNorth) {
            s\u03c6 = -1;
        } else {
            s\u03bb = -s\u03bb;
        }
        MatrixSIS normalize = this.context.getMatrix(ContextualParameters.MatrixRole.NORMALIZATION);
        MatrixSIS denormalize = this.context.getMatrix(ContextualParameters.MatrixRole.DENORMALIZATION);
        normalize.convertAfter(0, s\u03bb, variant == Variant.BELGIUM ? BELGE_A : null);
        normalize.convertAfter(1, s\u03c6, null);
        denormalize.convertBefore(0, F2, null);
        denormalize.convertBefore(1, -F2, rF);
    }

    LambertConicConformal(LambertConicConformal other) {
        super(other);
        this.n = other.n;
    }

    @Override
    final String[] getInternalParameterNames() {
        return new String[]{"n"};
    }

    @Override
    final double[] getInternalParameterValues() {
        return new double[]{this.n};
    }

    @Override
    public MathTransform createMapProjection(MathTransformFactory factory) throws FactoryException {
        LambertConicConformal kernel = this;
        if (this.eccentricity == 0.0) {
            kernel = new Spherical(this);
        }
        return kernel.completeWithWraparound(factory);
    }

    @Override
    public Optional<Envelope> getDomain(DomainDefinition criteria) {
        double x = this.getWraparoundLongitude();
        double y = Math.copySign(1.5707963267948966, -this.n);
        return Optional.of(new Envelope2D(null, -x, Math.min(y, 0.0), 2.0 * x, Math.abs(y)));
    }

    @Override
    public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) throws ProjectionException {
        double \u03c1;
        double sin\u03c6;
        double \u03b8 = srcPts[srcOff];
        double \u03c6 = srcPts[srcOff + 1];
        double abs\u03c6 = Math.abs(\u03c6);
        double sin\u03b8 = Math.sin(\u03b8);
        double cos\u03b8 = Math.cos(\u03b8);
        if (abs\u03c6 < 1.5707963267948966) {
            sin\u03c6 = Math.sin(\u03c6);
            \u03c1 = Math.pow(this.exp\u03a8(\u03c6, this.eccentricity * sin\u03c6), this.n);
        } else if (abs\u03c6 < 1.5707963283655673) {
            sin\u03c6 = 1.0;
            \u03c1 = \u03c6 * this.n >= 0.0 ? Double.POSITIVE_INFINITY : 0.0;
        } else {
            sin\u03c6 = Double.NaN;
            \u03c1 = Double.NaN;
        }
        double x = \u03c1 * sin\u03b8;
        double y = \u03c1 * cos\u03b8;
        if (dstPts != null) {
            dstPts[dstOff] = x;
            dstPts[dstOff + 1] = y;
        }
        if (!derivate) {
            return null;
        }
        double d\u03c1 = sin\u03c6 != 1.0 ? this.n * this.dy_d\u03c6(sin\u03c6, Math.cos(\u03c6)) * \u03c1 : \u03c1;
        return new Matrix2(y, d\u03c1 * sin\u03b8, -x, d\u03c1 * cos\u03b8);
    }

    @Override
    protected void inverseTransform(double[] srcPts, int srcOff, double[] dstPts, int dstOff) throws ProjectionException {
        double x = srcPts[srcOff];
        double y = srcPts[srcOff + 1];
        dstPts[dstOff] = Math.atan2(x, y);
        dstPts[dstOff + 1] = -this.\u03c6(Math.pow(Formulas.fastHypot(x, y), 1.0 / this.n));
    }

    private static enum Variant implements ProjectionVariant
    {
        BELGIUM(".*\\bBelgium\\b.*", "9803", false),
        MICHIGAN(".*\\bMichigan\\b.*", "1051", false),
        WEST(".*\\bWest\\b.*", "9826", true),
        ONE_PARALLEL(".*\\b1SP\\b.*", "9801", true),
        TWO_PARALLELS(".*\\b2SP\\b.*", "9802", false);

        private final Pattern operationName;
        private final String identifier;
        final boolean is1SP;

        private Variant(String operationName, String identifier, boolean is1SP) {
            this.operationName = Pattern.compile(operationName, 2);
            this.identifier = identifier;
            this.is1SP = is1SP;
        }

        @Override
        public Pattern getOperationNamePattern() {
            return this.operationName;
        }

        @Override
        public String getIdentifier() {
            return this.identifier;
        }
    }

    static final class Spherical
    extends LambertConicConformal {
        private static final long serialVersionUID = -8077690516096472987L;

        protected Spherical(LambertConicConformal other) {
            super(other);
        }

        @Override
        public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) {
            double \u03b8 = srcPts[srcOff];
            double \u03c6 = srcPts[srcOff + 1];
            double abs\u03c6 = Math.abs(\u03c6);
            double sin\u03b8 = Math.sin(\u03b8);
            double cos\u03b8 = Math.cos(\u03b8);
            double \u03c1 = abs\u03c6 < 1.5707963267948966 ? Math.pow(Math.tan(0.7853981633974483 + 0.5 * \u03c6), this.n) : (abs\u03c6 < 1.5707963283655673 ? (\u03c6 * this.n >= 0.0 ? Double.POSITIVE_INFINITY : 0.0) : Double.NaN);
            double x = \u03c1 * sin\u03b8;
            double y = \u03c1 * cos\u03b8;
            if (dstPts != null) {
                dstPts[dstOff] = x;
                dstPts[dstOff + 1] = y;
            }
            if (!derivate) {
                return null;
            }
            double d\u03c1 = abs\u03c6 < 1.5707963267948966 ? this.n * \u03c1 / Math.cos(\u03c6) : Double.NaN;
            return new Matrix2(y, d\u03c1 * sin\u03b8, -x, d\u03c1 * cos\u03b8);
        }

        @Override
        protected void inverseTransform(double[] srcPts, int srcOff, double[] dstPts, int dstOff) {
            double x = srcPts[srcOff];
            double y = srcPts[srcOff + 1];
            double \u03c1 = Math.hypot(x, y);
            dstPts[dstOff] = Math.atan2(x, y);
            dstPts[dstOff + 1] = 1.5707963267948966 - 2.0 * Math.atan(Math.pow(1.0 / \u03c1, 1.0 / this.n));
        }
    }
}

