/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.cp;

import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.BeanBuilder;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.common.internal.ThrowableUtils;
import org.apache.juneau.cp.BeanStore;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.internal.ObjectUtils;
import org.apache.juneau.internal.ResourceBundleUtils;
import org.apache.juneau.marshaller.Json5;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.utils.Tuple2;

public class Messages
extends ResourceBundle {
    private ResourceBundle rb;
    private Class<?> c;
    private Messages parent;
    private Locale locale;
    private final ConcurrentHashMap<Locale, Messages> localizedMessages = new ConcurrentHashMap();
    private final Map<String, String> keyMap;
    private final Set<String> rbKeys;

    public static final Builder create(Class<?> forClass) {
        return new Builder(forClass);
    }

    public static final Messages of(Class<?> forClass) {
        return (Messages)Messages.create(forClass).build();
    }

    public static final Messages of(Class<?> forClass, String name) {
        return (Messages)Messages.create(forClass).name(name).build();
    }

    protected Messages(Builder builder) {
        this(builder.forClass, builder.getBundle(), builder.locale, builder.parent);
    }

    Messages(Class<?> forClass, ResourceBundle rb, Locale locale, Messages parent) {
        this.c = forClass;
        this.rb = rb;
        this.parent = parent;
        if (parent != null) {
            this.setParent(parent);
        }
        this.locale = locale == null ? Locale.getDefault() : locale;
        TreeMap keyMap = new TreeMap();
        String cn = this.c.getSimpleName() + ".";
        if (rb != null) {
            rb.keySet().forEach(x -> {
                keyMap.put(x, x);
                if (x.startsWith(cn)) {
                    String shortKey = x.substring(cn.length());
                    keyMap.put(shortKey, x);
                }
            });
        }
        if (parent != null) {
            parent.keySet().forEach(x -> {
                keyMap.put(x, x);
                if (x.startsWith(cn)) {
                    String shortKey = x.substring(cn.length());
                    keyMap.put(shortKey, x);
                }
            });
        }
        this.keyMap = CollectionUtils.unmodifiable(CollectionUtils.copyOf(keyMap));
        this.rbKeys = rb == null ? Collections.emptySet() : rb.keySet();
    }

    public Messages forLocale(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (this.locale.equals(locale)) {
            return this;
        }
        Messages mb = this.localizedMessages.get(locale);
        if (mb == null) {
            Messages parent = this.parent == null ? null : this.parent.forLocale(locale);
            ResourceBundle rb = this.rb == null ? null : ResourceBundleUtils.findBundle(this.rb.getBaseBundleName(), locale, this.c.getClassLoader());
            mb = new Messages(this.c, rb, locale, parent);
            this.localizedMessages.put(locale, mb);
        }
        return mb;
    }

    public Set<String> keySet(String prefix) {
        LinkedHashSet<String> set = CollectionUtils.set(new String[0]);
        this.keySet().forEach(x -> {
            if (x.equals(prefix) || x.startsWith(prefix) && x.charAt(prefix.length()) == '.') {
                set.add((String)x);
            }
        });
        return set;
    }

    public String getString(String key, Object ... args) {
        String s = this.getString(key);
        if (s.startsWith("{!")) {
            return s;
        }
        return StringUtils.format(s, args);
    }

    public String findFirstString(String ... keys) {
        for (String k : keys) {
            if (!this.containsKey(k)) continue;
            return this.getString(k);
        }
        return null;
    }

    @Override
    protected Object handleGetObject(String key) {
        String k = this.keyMap.get(key);
        if (k == null) {
            return "{!" + key + "}";
        }
        try {
            if (this.rbKeys.contains(k)) {
                return this.rb.getObject(k);
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return this.parent.handleGetObject(key);
    }

    @Override
    public boolean containsKey(String key) {
        return this.keyMap.containsKey(key);
    }

    @Override
    public Set<String> keySet() {
        return this.keyMap.keySet();
    }

    @Override
    public Enumeration<String> getKeys() {
        return Collections.enumeration(this.keySet());
    }

    public String toString() {
        JsonMap m = new JsonMap();
        for (String k : new TreeSet<String>(this.keySet())) {
            m.put(k, (Object)this.getString(k));
        }
        return Json5.of(m);
    }

    @FluentSetters
    public static class Builder
    extends BeanBuilder<Messages> {
        Class<?> forClass;
        Locale locale;
        String name;
        Messages parent;
        List<Tuple2<Class<?>, String>> locations;
        private String[] baseNames = new String[]{"{package}.{name}", "{package}.i18n.{name}", "{package}.nls.{name}", "{package}.messages.{name}"};

        protected Builder(Class<?> forClass) {
            super(Messages.class, BeanStore.INSTANCE);
            this.forClass = forClass;
            this.name = forClass.getSimpleName();
            this.locations = CollectionUtils.list(new Tuple2[0]);
            this.locale = Locale.getDefault();
        }

        @Override
        protected Messages buildDefault() {
            if (!this.locations.isEmpty()) {
                Tuple2[] mbl = this.locations.toArray(new Tuple2[0]);
                BeanBuilder x = null;
                for (int i = mbl.length - 1; i >= 0; --i) {
                    Class c = ObjectUtils.firstNonNull((Class)mbl[i].getA(), this.forClass);
                    String value = (String)mbl[i].getB();
                    if (StringUtils.isJsonObject(value, true)) {
                        MessagesString ms;
                        try {
                            ms = Json5.DEFAULT.read(value, MessagesString.class);
                        }
                        catch (ParseException e) {
                            throw ThrowableUtils.asRuntimeException(e);
                        }
                        x = Messages.create(c).name(ms.name).baseNames(StringUtils.split(ms.baseNames, ',')).locale(ms.locale).parent(x == null ? null : (Messages)x.build());
                        continue;
                    }
                    x = Messages.create(c).name(value).parent(x == null ? null : (Messages)x.build());
                }
                return x == null ? null : (Messages)x.build();
            }
            return new Messages(this);
        }

        public Builder parent(Messages parent) {
            this.parent = parent;
            return this;
        }

        public Builder name(String name) {
            this.name = StringUtils.isEmpty(name) ? this.forClass.getSimpleName() : name;
            return this;
        }

        public Builder baseNames(String ... baseNames) {
            this.baseNames = baseNames == null ? new String[]{} : baseNames;
            return this;
        }

        public Builder locale(Locale locale) {
            this.locale = locale == null ? Locale.getDefault() : locale;
            return this;
        }

        public Builder locale(String locale) {
            return this.locale(locale == null ? null : Locale.forLanguageTag(locale));
        }

        public Builder location(Class<?> baseClass, String bundlePath) {
            this.locations.add(0, Tuple2.of(baseClass, bundlePath));
            return this;
        }

        public Builder location(String bundlePath) {
            this.locations.add(0, Tuple2.of(this.forClass, bundlePath));
            return this;
        }

        public Builder impl(Object value) {
            super.impl(value);
            return this;
        }

        public Builder type(Class<?> value) {
            super.type(value);
            return this;
        }

        ResourceBundle getBundle() {
            ClassLoader cl = this.forClass.getClassLoader();
            JsonMap m = JsonMap.of(new Object[]{"name", this.name, "package", this.forClass.getPackage().getName()});
            for (String bn : this.baseNames) {
                ResourceBundle rb = ResourceBundleUtils.findBundle(bn = StringUtils.replaceVars(bn, m), this.locale, cl);
                if (rb == null) continue;
                return rb;
            }
            return null;
        }

        private static class MessagesString {
            public String name;
            public String[] baseNames;
            public String locale;

            private MessagesString() {
            }
        }
    }
}

