/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.objecttools;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.ReaderParser;

public final class ObjectIntrospector {
    private final Object object;
    private final ReaderParser parser;

    public static ObjectIntrospector create(Object o) {
        return new ObjectIntrospector(o);
    }

    public static ObjectIntrospector create(Object o, ReaderParser parser) {
        return new ObjectIntrospector(o, parser);
    }

    public ObjectIntrospector(Object object, ReaderParser parser) {
        if (parser == null) {
            parser = JsonParser.DEFAULT;
        }
        this.object = object;
        this.parser = parser;
    }

    public ObjectIntrospector(Object o) {
        this(o, null);
    }

    public Object invokeMethod(Method method, Reader args) throws InvocationTargetException, IllegalArgumentException, IllegalAccessException, ParseException, IOException {
        if (this.object == null) {
            return null;
        }
        Object[] params = args == null ? null : this.parser.parseArgs(args, method.getGenericParameterTypes());
        return method.invoke(this.object, params);
    }

    public <T> T invokeMethod(Class<T> returnType, Method method, Reader args) throws InvocationTargetException, IllegalArgumentException, IllegalAccessException, ParseException, IOException {
        return returnType.cast(this.invokeMethod(method, args));
    }

    public Object invokeMethod(String method, String args) throws NoSuchMethodException, IllegalArgumentException, InvocationTargetException, IllegalAccessException, ParseException, IOException {
        if (this.object == null) {
            return null;
        }
        Method m = this.parser.getBeanContext().getClassMeta(this.object.getClass()).getPublicMethods().get(method);
        if (m == null) {
            throw new NoSuchMethodException(method);
        }
        return this.invokeMethod(m, args == null ? null : new StringReader(args));
    }

    public <T> T invokeMethod(Class<T> returnType, String method, String args) throws NoSuchMethodException, IllegalArgumentException, InvocationTargetException, IllegalAccessException, ParseException, IOException {
        return returnType.cast(this.invokeMethod(method, args));
    }
}

