/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.simple;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.io.FilenameUtils;
import org.apache.knox.gateway.topology.simple.JSONProviderConfiguration;
import org.apache.knox.gateway.topology.simple.ProviderConfiguration;
import org.apache.knox.gateway.topology.simple.XMLProviderConfiguration;

public class ProviderConfigurationParser {
    private static final JAXBContext jaxbContext = ProviderConfigurationParser.getJAXBContext();
    private static final String EXT_XML = "xml";
    private static final String EXT_JSON = "json";
    private static final String EXT_YML = "yml";
    private static final String EXT_YAML = "yaml";
    public static final List<String> SUPPORTED_EXTENSIONS = Collections.unmodifiableList(Arrays.asList("xml", "json", "yml", "yaml"));

    private static JAXBContext getJAXBContext() {
        try {
            return JAXBContext.newInstance((Class[])new Class[]{XMLProviderConfiguration.class});
        }
        catch (JAXBException e) {
            throw new IllegalStateException(e);
        }
    }

    public static ProviderConfiguration parse(String path) throws Exception {
        return ProviderConfigurationParser.parse(new File(path));
    }

    public static ProviderConfiguration parse(File file) throws Exception {
        ProviderConfiguration providerConfig = null;
        String extension = FilenameUtils.getExtension((String)file.getName());
        if (SUPPORTED_EXTENSIONS.contains(extension)) {
            if (ProviderConfigurationParser.isXML(extension)) {
                providerConfig = ProviderConfigurationParser.parseXML(file);
            } else if (ProviderConfigurationParser.isJSON(extension)) {
                providerConfig = ProviderConfigurationParser.parseJSON(file);
            } else if (ProviderConfigurationParser.isYAML(extension)) {
                providerConfig = ProviderConfigurationParser.parseYAML(file);
            }
        } else {
            throw new IllegalArgumentException("Unsupported provider configuration format: " + extension);
        }
        return providerConfig;
    }

    private static boolean isXML(String extension) {
        return EXT_XML.equals(extension);
    }

    private static boolean isJSON(String extension) {
        return EXT_JSON.equals(extension);
    }

    private static boolean isYAML(String extension) {
        return EXT_YAML.equals(extension) || EXT_YML.equals(extension);
    }

    static ProviderConfiguration parseXML(File file) throws Exception {
        return ProviderConfigurationParser.parseXML(Files.newInputStream(file.toPath(), new OpenOption[0]));
    }

    static ProviderConfiguration parseXML(InputStream in) throws Exception {
        Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
        XMLProviderConfiguration providerConfig = (XMLProviderConfiguration)jaxbUnmarshaller.unmarshal(in);
        return providerConfig;
    }

    static ProviderConfiguration parseJSON(File file) throws IOException {
        return ProviderConfigurationParser.parseJSON(Files.newInputStream(file.toPath(), new OpenOption[0]));
    }

    static ProviderConfiguration parseJSON(InputStream in) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        return (ProviderConfiguration)mapper.readValue(in, JSONProviderConfiguration.class);
    }

    static ProviderConfiguration parseYAML(File file) throws IOException {
        return ProviderConfigurationParser.parseYAML(Files.newInputStream(file.toPath(), new OpenOption[0]));
    }

    static ProviderConfiguration parseYAML(InputStream in) throws IOException {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        return (ProviderConfiguration)mapper.readValue(in, JSONProviderConfiguration.class);
    }
}

