/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.cm;

import com.cloudera.api.swagger.RolesResourceApi;
import com.cloudera.api.swagger.client.ApiException;
import com.cloudera.api.swagger.model.ApiConfigList;
import com.cloudera.api.swagger.model.ApiRole;
import com.cloudera.api.swagger.model.ApiRoleConfig;
import com.cloudera.api.swagger.model.ApiRoleConfigList;
import com.cloudera.api.swagger.model.ApiRoleList;
import java.util.ArrayList;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.topology.discovery.cm.ClouderaManagerServiceDiscoveryMessages;
import org.apache.knox.gateway.topology.discovery.cm.ServiceRoleCollector;
import org.apache.knox.gateway.topology.discovery.cm.TypeNameFilter;

public class ServiceRoleCollectorByRole
implements ServiceRoleCollector {
    private static final String VIEW_FULL = "full";
    private final RolesResourceApi rolesResourceApi;
    private final TypeNameFilter roleTypeNameFilter;
    private static final ClouderaManagerServiceDiscoveryMessages log = (ClouderaManagerServiceDiscoveryMessages)MessagesFactory.get(ClouderaManagerServiceDiscoveryMessages.class);

    public ServiceRoleCollectorByRole(RolesResourceApi rolesResourceApi, TypeNameFilter roleTypeNameFilter) {
        this.rolesResourceApi = rolesResourceApi;
        this.roleTypeNameFilter = roleTypeNameFilter;
    }

    @Override
    public ApiRoleConfigList getAllServiceRoleConfigurations(String clusterName, String serviceName) throws ApiException {
        ApiRoleConfigList allServiceRoleConfigs = new ApiRoleConfigList();
        allServiceRoleConfigs.setItems(new ArrayList());
        ApiRoleList roles = this.rolesResourceApi.readRoles(clusterName, serviceName, "", VIEW_FULL);
        if (roles == null || roles.getItems() == null) {
            log.receivedNullServiceRoleList(serviceName, clusterName);
            return allServiceRoleConfigs;
        }
        for (ApiRole role : roles.getItems()) {
            String roleName = role.getName();
            if (this.roleTypeNameFilter.isExcluded(role.getType())) {
                log.skipRoleDiscovery(role.getName(), role.getType());
                continue;
            }
            log.fetchingServiceRoleConfigs(serviceName, clusterName, roleName);
            ApiConfigList config = this.rolesResourceApi.readRoleConfig(clusterName, role.getName(), serviceName, VIEW_FULL);
            if (config != null && config.getItems() != null) {
                ApiRoleConfig roleConfig = new ApiRoleConfig().roleType(role.getType()).name(role.getName()).hostRef(role.getHostRef()).config(config);
                allServiceRoleConfigs.getItems().add(roleConfig);
                continue;
            }
            log.receivedNullServiceRoleConfigs(serviceName, clusterName, roleName);
        }
        return allServiceRoleConfigs;
    }
}

