/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.concurrent;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import org.ldaptive.Connection;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.LdapException;
import org.ldaptive.LdapUtils;
import org.ldaptive.Request;
import org.ldaptive.Response;
import org.ldaptive.SearchEntry;
import org.ldaptive.SearchFilter;
import org.ldaptive.SearchOperation;
import org.ldaptive.SearchReference;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchResult;
import org.ldaptive.concurrent.AbstractSearchExecutor;
import org.ldaptive.handler.HandlerResult;
import org.ldaptive.intermediate.IntermediateResponse;

public class QueueingSearchExecutor
extends AbstractSearchExecutor {
    private final int queueCapacity;

    public QueueingSearchExecutor() {
        this(Integer.MAX_VALUE, Executors.newCachedThreadPool());
    }

    public QueueingSearchExecutor(int capacity) {
        this(capacity, Executors.newCachedThreadPool());
    }

    public QueueingSearchExecutor(ExecutorService es) {
        this(Integer.MAX_VALUE, es);
    }

    public QueueingSearchExecutor(int capacity, ExecutorService es) {
        super(es);
        this.queueCapacity = capacity;
    }

    public BlockingQueue<SearchItem> search(ConnectionFactory factory) throws LdapException {
        return this.search(factory, null, (String[])null, (org.ldaptive.handler.SearchEntryHandler[])null);
    }

    public BlockingQueue<SearchItem> search(ConnectionFactory factory, String filter) throws LdapException {
        return this.search(factory, new SearchFilter(filter), (String[])null, (org.ldaptive.handler.SearchEntryHandler[])null);
    }

    public BlockingQueue<SearchItem> search(ConnectionFactory factory, SearchFilter filter) throws LdapException {
        return this.search(factory, filter, (String[])null, (org.ldaptive.handler.SearchEntryHandler[])null);
    }

    public BlockingQueue<SearchItem> search(ConnectionFactory factory, String filter, String ... attrs) throws LdapException {
        return this.search(factory, new SearchFilter(filter), attrs, (org.ldaptive.handler.SearchEntryHandler[])null);
    }

    public BlockingQueue<SearchItem> search(ConnectionFactory factory, SearchFilter filter, String ... attrs) throws LdapException {
        return this.search(factory, filter, attrs, (org.ldaptive.handler.SearchEntryHandler[])null);
    }

    public BlockingQueue<SearchItem> search(ConnectionFactory factory, SearchFilter filter, String[] attrs, org.ldaptive.handler.SearchEntryHandler ... handlers) throws LdapException {
        LinkedBlockingQueue<SearchItem> queue = new LinkedBlockingQueue<SearchItem>(this.queueCapacity);
        SearchRequest sr = QueueingSearchExecutor.newSearchRequest(this);
        if (filter != null) {
            sr.setSearchFilter(filter);
        }
        if (attrs != null) {
            sr.setReturnAttributes(attrs);
        }
        if (handlers != null) {
            sr.setSearchEntryHandlers(handlers);
        }
        this.configureSearchRequest(sr, queue);
        Connection conn = factory.getConnection();
        SearchOperation op = this.createSearchOperation(conn);
        ExecutorService service = this.getExecutorService();
        service.submit(this.createCallable(conn, op, sr, queue));
        return queue;
    }

    protected Callable<Response<SearchResult>> createCallable(final Connection conn, final SearchOperation operation, final SearchRequest request, final BlockingQueue<SearchItem> queue) {
        return new Callable<Response<SearchResult>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Response<SearchResult> call() throws LdapException {
                try {
                    SearchItem item;
                    conn.open();
                    try {
                        Response<SearchResult> response = operation.execute(request);
                        item = new SearchItem(response);
                    }
                    catch (Exception e) {
                        item = new SearchItem(e);
                    }
                    try {
                        QueueingSearchExecutor.this.logger.debug("received {}", (Object)item);
                        queue.put(item);
                    }
                    catch (InterruptedException e1) {
                        QueueingSearchExecutor.this.logger.warn("Unable to insert item {}", (Object)item);
                    }
                    Response<SearchResult> response = null;
                    return response;
                }
                finally {
                    conn.close();
                }
            }
        };
    }

    protected void configureSearchRequest(SearchRequest request, BlockingQueue<SearchItem> queue) {
        if (request.getSearchEntryHandlers() != null) {
            request.setSearchEntryHandlers(LdapUtils.concatArrays(request.getSearchEntryHandlers(), new org.ldaptive.handler.SearchEntryHandler[][]{{new SearchEntryHandler(queue)}}));
        } else {
            request.setSearchEntryHandlers(new SearchEntryHandler(queue));
        }
        if (request.getSearchReferenceHandlers() != null) {
            request.setSearchReferenceHandlers(LdapUtils.concatArrays(request.getSearchReferenceHandlers(), new org.ldaptive.handler.SearchReferenceHandler[][]{{new SearchReferenceHandler(queue)}}));
        } else {
            request.setSearchReferenceHandlers(new SearchReferenceHandler(queue));
        }
        if (request.getIntermediateResponseHandlers() != null) {
            request.setIntermediateResponseHandlers(LdapUtils.concatArrays(request.getIntermediateResponseHandlers(), new org.ldaptive.handler.IntermediateResponseHandler[][]{{new IntermediateResponseHandler(queue)}}));
        } else {
            request.setIntermediateResponseHandlers(new IntermediateResponseHandler(queue));
        }
    }

    public static class SearchItem {
        private final SearchEntry searchEntry;
        private final SearchReference searchReference;
        private final IntermediateResponse intermediateResponse;
        private final Response<SearchResult> searchResponse;
        private final Exception searchException;

        public SearchItem(SearchEntry entry) {
            this.searchEntry = entry;
            this.searchReference = null;
            this.intermediateResponse = null;
            this.searchResponse = null;
            this.searchException = null;
        }

        public SearchItem(SearchReference reference) {
            this.searchEntry = null;
            this.searchReference = reference;
            this.intermediateResponse = null;
            this.searchResponse = null;
            this.searchException = null;
        }

        public SearchItem(IntermediateResponse response) {
            this.searchEntry = null;
            this.searchReference = null;
            this.intermediateResponse = response;
            this.searchResponse = null;
            this.searchException = null;
        }

        public SearchItem(Response<SearchResult> response) {
            this.searchEntry = null;
            this.searchReference = null;
            this.intermediateResponse = null;
            this.searchResponse = response;
            this.searchException = null;
        }

        public SearchItem(Exception exception) {
            this.searchEntry = null;
            this.searchReference = null;
            this.intermediateResponse = null;
            this.searchResponse = null;
            this.searchException = exception;
        }

        public boolean isEntry() {
            return this.searchEntry != null;
        }

        public SearchEntry getEntry() {
            return this.searchEntry;
        }

        public boolean isReference() {
            return this.searchReference != null;
        }

        public SearchReference getReference() {
            return this.searchReference;
        }

        public boolean isIntermediateResponse() {
            return this.intermediateResponse != null;
        }

        public IntermediateResponse getIntermediateResponse() {
            return this.intermediateResponse;
        }

        public boolean isResponse() {
            return this.searchResponse != null;
        }

        public Response<SearchResult> getResponse() {
            return this.searchResponse;
        }

        public boolean isException() {
            return this.searchException != null;
        }

        public Exception getException() {
            return this.searchException;
        }

        public String toString() {
            String s = this.isEntry() ? String.format("[%s@%d::searchEntry=%s]", this.getClass().getName(), this.hashCode(), this.searchEntry) : (this.isReference() ? String.format("[%s@%d::searchReference=%s]", this.getClass().getName(), this.hashCode(), this.searchReference) : (this.isIntermediateResponse() ? String.format("[%s@%d::intermediateResponse=%s]", this.getClass().getName(), this.hashCode(), this.intermediateResponse) : (this.isResponse() ? String.format("[%s@%d::searchResponse=%s]", this.getClass().getName(), this.hashCode(), this.searchResponse) : (this.isException() ? String.format("[%s@%d::searchException=%s]", this.getClass().getName(), this.hashCode(), this.searchException) : String.format("[%s@%d]", this.getClass().getName(), this.hashCode())))));
            return s;
        }
    }

    protected abstract class AbstractHandler {
        private final BlockingQueue<SearchItem> queue;

        public AbstractHandler(BlockingQueue<SearchItem> q) {
            this.queue = q;
        }

        protected void insert(SearchItem item) {
            try {
                QueueingSearchExecutor.this.logger.debug("received {}", (Object)item);
                this.queue.put(item);
            }
            catch (Exception e) {
                QueueingSearchExecutor.this.logger.warn("Unable to insert item {}", (Object)item);
            }
        }
    }

    protected class IntermediateResponseHandler
    extends AbstractHandler
    implements org.ldaptive.handler.IntermediateResponseHandler {
        public IntermediateResponseHandler(BlockingQueue<SearchItem> q) {
            super(q);
        }

        @Override
        public HandlerResult<IntermediateResponse> handle(Connection conn, Request request, IntermediateResponse response) throws LdapException {
            this.insert(new SearchItem(response));
            return new HandlerResult<IntermediateResponse>(response);
        }
    }

    protected class SearchReferenceHandler
    extends AbstractHandler
    implements org.ldaptive.handler.SearchReferenceHandler {
        public SearchReferenceHandler(BlockingQueue<SearchItem> q) {
            super(q);
        }

        @Override
        public HandlerResult<SearchReference> handle(Connection conn, SearchRequest request, SearchReference reference) throws LdapException {
            this.insert(new SearchItem(reference));
            return new HandlerResult<SearchReference>(reference);
        }

        @Override
        public void initializeRequest(SearchRequest request) {
        }
    }

    protected class SearchEntryHandler
    extends AbstractHandler
    implements org.ldaptive.handler.SearchEntryHandler {
        public SearchEntryHandler(BlockingQueue<SearchItem> q) {
            super(q);
        }

        @Override
        public HandlerResult<SearchEntry> handle(Connection conn, SearchRequest request, SearchEntry entry) throws LdapException {
            this.insert(new SearchItem(entry));
            return new HandlerResult<SearchEntry>(entry);
        }

        @Override
        public void initializeRequest(SearchRequest request) {
        }
    }
}

