/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors;

import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;

public class MetadataHelper {
    private MetadataHelper() {
        throw new UnsupportedOperationException("Instances of MetadataHelper are not allowed");
    }

    public static void buildColsFromMappings(StringBuilder target, Collection<? extends MetadataAccessor> mappings, String separator) {
        Iterator<? extends MetadataAccessor> i = mappings.iterator();
        while (i.hasNext()) {
            target.append(i.next().getName().toUpperCase(Locale.ROOT));
            if (!i.hasNext()) continue;
            target.append(separator);
        }
    }

    public static void buildValuesAsQMarksFromMappings(StringBuilder target, Collection<? extends MetadataAccessor> mappings, String separator) {
        int count = mappings.size();
        if (count > 0) {
            int i = 0;
            while (i < count) {
                if (i > 0) {
                    target.append(separator);
                }
                target.append('?');
                ++i;
            }
        }
    }

    public static void buildColsAndValuesBindingsFromMappings(StringBuilder target, Collection<? extends MetadataAccessor> mappings, int valueIndex, String binder, String separator) {
        int idx = valueIndex;
        Iterator<? extends MetadataAccessor> i = mappings.iterator();
        while (i.hasNext()) {
            target.append(i.next().getName().toUpperCase(Locale.ROOT)).append(binder).append(Integer.toString(++idx));
            if (!i.hasNext()) continue;
            target.append(separator);
        }
    }
}

