/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.cm.collector;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.knox.gateway.topology.discovery.cm.ServiceModel;
import org.apache.knox.gateway.topology.discovery.cm.collector.AbstractURLCollector;

public class HueURLCollector
extends AbstractURLCollector {
    private static final String SCHEME_HTTP = "http";
    private static final String SCHEME_HTTPS = "https";

    @Override
    protected List<String> getURLs(Map<String, List<ServiceModel>> roleModels) {
        ArrayList<String> urls = new ArrayList<String>();
        if (roleModels.containsKey("HUE_LOAD_BALANCER")) {
            List<String> lbUrls = this.getURLs(roleModels.get("HUE_LOAD_BALANCER"));
            if (roleModels.get("HUE_SERVER").get(0).getServiceUrl().startsWith(SCHEME_HTTPS)) {
                for (String url : lbUrls) {
                    urls.add(url.replace(SCHEME_HTTP, SCHEME_HTTPS));
                }
            } else {
                urls.addAll(lbUrls);
            }
        } else {
            for (List<ServiceModel> models : roleModels.values()) {
                urls.addAll(this.getURLs(models));
            }
        }
        return urls;
    }
}

