/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oidc.profile;

import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import java.util.Arrays;
import org.pac4j.core.profile.converter.AttributeConverter;
import org.pac4j.core.profile.converter.Converters;
import org.pac4j.core.profile.definition.CommonProfileDefinition;
import org.pac4j.core.profile.factory.ProfileFactory;
import org.pac4j.oidc.profile.OidcProfile;
import org.pac4j.oidc.profile.converter.OidcLongTimeConverter;

public class OidcProfileDefinition<P extends OidcProfile>
extends CommonProfileDefinition<P> {
    public static final String NAME = "name";
    public static final String GIVEN_NAME = "given_name";
    public static final String MIDDLE_NAME = "middle_name";
    public static final String NICKNAME = "nickname";
    public static final String PREFERRED_USERNAME = "preferred_username";
    public static final String PROFILE = "profile";
    public static final String PICTURE = "picture";
    public static final String WEBSITE = "website";
    public static final String EMAIL_VERIFIED = "email_verified";
    public static final String BIRTHDATE = "birthdate";
    public static final String ZONEINFO = "zoneinfo";
    public static final String PHONE_NUMBER = "phone_number";
    public static final String PHONE_NUMBER_VERIFIED = "phone_number_verified";
    public static final String ADDRESS = "address";
    public static final String UPDATED_AT = "updated_at";
    public static final String ACCESS_TOKEN = "access_token";
    public static final String ID_TOKEN = "id_token";
    public static final String REFRESH_TOKEN = "refresh_token";
    public static final String AUTH_TIME = "auth_time";
    public static final String NONCE = "nonce";
    public static final String ACR = "acr";
    public static final String AMR = "amr";
    public static final String AZP = "azp";
    public static final String TOKEN_EXPIRATION_ADVANCE = "token_expiration_advance";
    public static final String EXPIRATION = "expiration";

    public OidcProfileDefinition() {
        super(x -> new OidcProfile());
        Arrays.stream(new String[]{NAME, GIVEN_NAME, MIDDLE_NAME, NICKNAME, PREFERRED_USERNAME, WEBSITE, PHONE_NUMBER, ZONEINFO, ID_TOKEN}).forEach(a -> this.primary((String)a, (AttributeConverter)Converters.STRING));
        this.primary(PROFILE, (AttributeConverter)Converters.URL);
        this.primary(PICTURE, (AttributeConverter)Converters.URL);
        this.primary(EMAIL_VERIFIED, (AttributeConverter)Converters.BOOLEAN);
        this.primary(PHONE_NUMBER_VERIFIED, (AttributeConverter)Converters.BOOLEAN);
        this.primary(UPDATED_AT, new OidcLongTimeConverter());
        this.primary(ACCESS_TOKEN, attribute -> {
            if (attribute instanceof AccessToken) {
                return attribute;
            }
            if (attribute instanceof String) {
                return new BearerAccessToken((String)attribute);
            }
            return null;
        });
        this.primary(REFRESH_TOKEN, attribute -> {
            if (attribute instanceof RefreshToken) {
                return attribute;
            }
            if (attribute instanceof String) {
                return new RefreshToken((String)attribute);
            }
            return null;
        });
        Arrays.stream(new String[]{"sub", "iss", NONCE, ACR, AZP}).forEach(a -> this.primary((String)a, (AttributeConverter)Converters.STRING));
        Arrays.stream(new String[]{"exp", "iat", "nbf"}).forEach(a -> this.primary((String)a, (AttributeConverter)Converters.DATE_TZ_GENERAL));
        this.primary(AUTH_TIME, new OidcLongTimeConverter());
        this.secondary(TOKEN_EXPIRATION_ADVANCE, (AttributeConverter)Converters.INTEGER);
        this.secondary(EXPIRATION, (AttributeConverter)Converters.DATE_TZ_RFC822);
    }

    public OidcProfileDefinition(ProfileFactory<P> profileFactory) {
        this();
        this.setProfileFactory(profileFactory);
    }
}

