/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Arguments used for HDFS HA commands.")
public class ApiHdfsHaArguments {
    @SerializedName(value="activeName")
    private String activeName = null;
    @SerializedName(value="activeSharedEditsPath")
    private String activeSharedEditsPath = null;
    @SerializedName(value="standByName")
    private String standByName = null;
    @SerializedName(value="standBySharedEditsPath")
    private String standBySharedEditsPath = null;
    @SerializedName(value="nameservice")
    private String nameservice = null;
    @SerializedName(value="startDependentServices")
    private Boolean startDependentServices = null;
    @SerializedName(value="deployClientConfigs")
    private Boolean deployClientConfigs = null;
    @SerializedName(value="enableQuorumStorage")
    private Boolean enableQuorumStorage = null;

    public ApiHdfsHaArguments activeName(String activeName) {
        this.activeName = activeName;
        return this;
    }

    @Schema(description="Name of the active NameNode.")
    public String getActiveName() {
        return this.activeName;
    }

    public void setActiveName(String activeName) {
        this.activeName = activeName;
    }

    public ApiHdfsHaArguments activeSharedEditsPath(String activeSharedEditsPath) {
        this.activeSharedEditsPath = activeSharedEditsPath;
        return this;
    }

    @Schema(description="Path to the shared edits directory on the active NameNode's host. Ignored if Quorum-based Storage is being enabled.")
    public String getActiveSharedEditsPath() {
        return this.activeSharedEditsPath;
    }

    public void setActiveSharedEditsPath(String activeSharedEditsPath) {
        this.activeSharedEditsPath = activeSharedEditsPath;
    }

    public ApiHdfsHaArguments standByName(String standByName) {
        this.standByName = standByName;
        return this;
    }

    @Schema(description="Name of the stand-by Namenode.")
    public String getStandByName() {
        return this.standByName;
    }

    public void setStandByName(String standByName) {
        this.standByName = standByName;
    }

    public ApiHdfsHaArguments standBySharedEditsPath(String standBySharedEditsPath) {
        this.standBySharedEditsPath = standBySharedEditsPath;
        return this;
    }

    @Schema(description="Path to the shared edits directory on the stand-by NameNode's host. Ignored if Quorum-based Storage is being enabled.")
    public String getStandBySharedEditsPath() {
        return this.standBySharedEditsPath;
    }

    public void setStandBySharedEditsPath(String standBySharedEditsPath) {
        this.standBySharedEditsPath = standBySharedEditsPath;
    }

    public ApiHdfsHaArguments nameservice(String nameservice) {
        this.nameservice = nameservice;
        return this;
    }

    @Schema(description="Nameservice that identifies the HA pair.")
    public String getNameservice() {
        return this.nameservice;
    }

    public void setNameservice(String nameservice) {
        this.nameservice = nameservice;
    }

    public ApiHdfsHaArguments startDependentServices(Boolean startDependentServices) {
        this.startDependentServices = startDependentServices;
        return this;
    }

    @Schema(description="Whether to re-start dependent services. Defaults to true.")
    public Boolean isStartDependentServices() {
        return this.startDependentServices;
    }

    public void setStartDependentServices(Boolean startDependentServices) {
        this.startDependentServices = startDependentServices;
    }

    public ApiHdfsHaArguments deployClientConfigs(Boolean deployClientConfigs) {
        this.deployClientConfigs = deployClientConfigs;
        return this;
    }

    @Schema(description="Whether to re-deploy client configurations. Defaults to true.")
    public Boolean isDeployClientConfigs() {
        return this.deployClientConfigs;
    }

    public void setDeployClientConfigs(Boolean deployClientConfigs) {
        this.deployClientConfigs = deployClientConfigs;
    }

    public ApiHdfsHaArguments enableQuorumStorage(Boolean enableQuorumStorage) {
        this.enableQuorumStorage = enableQuorumStorage;
        return this;
    }

    @Schema(description="This parameter has been deprecated as of CM 5.0, where HA is only supported using Quorum-based Storage. <p> Whether to enable Quorum-based Storage.  Enabling Quorum-based Storage requires a minimum of three and an odd number of JournalNodes to be created and configured before enabling HDFS HA. <p> Available since API v2.")
    public Boolean isEnableQuorumStorage() {
        return this.enableQuorumStorage;
    }

    public void setEnableQuorumStorage(Boolean enableQuorumStorage) {
        this.enableQuorumStorage = enableQuorumStorage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiHdfsHaArguments apiHdfsHaArguments = (ApiHdfsHaArguments)o;
        return Objects.equals(this.activeName, apiHdfsHaArguments.activeName) && Objects.equals(this.activeSharedEditsPath, apiHdfsHaArguments.activeSharedEditsPath) && Objects.equals(this.standByName, apiHdfsHaArguments.standByName) && Objects.equals(this.standBySharedEditsPath, apiHdfsHaArguments.standBySharedEditsPath) && Objects.equals(this.nameservice, apiHdfsHaArguments.nameservice) && Objects.equals(this.startDependentServices, apiHdfsHaArguments.startDependentServices) && Objects.equals(this.deployClientConfigs, apiHdfsHaArguments.deployClientConfigs) && Objects.equals(this.enableQuorumStorage, apiHdfsHaArguments.enableQuorumStorage);
    }

    public int hashCode() {
        return Objects.hash(this.activeName, this.activeSharedEditsPath, this.standByName, this.standBySharedEditsPath, this.nameservice, this.startDependentServices, this.deployClientConfigs, this.enableQuorumStorage);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiHdfsHaArguments {\n");
        sb.append("    activeName: ").append(this.toIndentedString(this.activeName)).append("\n");
        sb.append("    activeSharedEditsPath: ").append(this.toIndentedString(this.activeSharedEditsPath)).append("\n");
        sb.append("    standByName: ").append(this.toIndentedString(this.standByName)).append("\n");
        sb.append("    standBySharedEditsPath: ").append(this.toIndentedString(this.standBySharedEditsPath)).append("\n");
        sb.append("    nameservice: ").append(this.toIndentedString(this.nameservice)).append("\n");
        sb.append("    startDependentServices: ").append(this.toIndentedString(this.startDependentServices)).append("\n");
        sb.append("    deployClientConfigs: ").append(this.toIndentedString(this.deployClientConfigs)).append("\n");
        sb.append("    enableQuorumStorage: ").append(this.toIndentedString(this.enableQuorumStorage)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

