/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.shell.alias;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.apache.knox.gateway.shell.BasicResponse;
import org.apache.knox.gateway.shell.KnoxShellException;

public class AliasResponse
extends BasicResponse {
    private static final String CONTENT_TYPE = "application/json";
    private String responseContent;
    protected Map<String, Object> parsedResponse;
    protected String cluster;

    AliasResponse(HttpResponse response) {
        super(response);
        this.parseResponseEntity();
    }

    private void parseResponseEntity() {
        if (!this.isExpectedResponseStatus()) {
            throw new KnoxShellException("Unexpected response: " + this.response().getStatusLine().getReasonPhrase());
        }
        HttpEntity entity = this.response().getEntity();
        if (entity == null) {
            throw new KnoxShellException("Missing expected response content");
        }
        String contentType = entity.getContentType().getValue();
        if (!CONTENT_TYPE.equals(contentType)) {
            throw new KnoxShellException("Unexpected response content type: " + contentType);
        }
        try {
            this.responseContent = EntityUtils.toString((HttpEntity)entity);
            this.parsedResponse = (Map)new ObjectMapper().readValue(this.responseContent, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (Exception e) {
            throw new KnoxShellException("Unable to process response content", e);
        }
    }

    protected boolean isExpectedResponseStatus() {
        return this.response().getStatusLine().getStatusCode() == 200;
    }

    public String getCluster() {
        return this.cluster;
    }

    public String getResponseContent() {
        return this.responseContent;
    }
}

