/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.coprocessor.shaded.com.tdunning.math.stats;

import java.nio.ByteBuffer;
import java.util.Collection;
import org.apache.kylin.coprocessor.shaded.com.tdunning.math.stats.AVLTreeDigest;
import org.apache.kylin.coprocessor.shaded.com.tdunning.math.stats.ArrayDigest;
import org.apache.kylin.coprocessor.shaded.com.tdunning.math.stats.Centroid;
import org.apache.kylin.coprocessor.shaded.com.tdunning.math.stats.TreeDigest;

public abstract class TDigest {
    public static ArrayDigest createArrayDigest(double compression) {
        return new ArrayDigest(32, compression);
    }

    public static ArrayDigest createArrayDigest(int pageSize, double compression) {
        return new ArrayDigest(pageSize, compression);
    }

    public static TDigest createTreeDigest(double compression) {
        return new TreeDigest(compression);
    }

    public static TDigest createAvlTreeDigest(double compression) {
        return new AVLTreeDigest(compression);
    }

    public static TDigest createDigest(double compression) {
        return TDigest.createAvlTreeDigest(compression);
    }

    public abstract void add(double var1, int var3);

    protected final void checkValue(double x) {
        if (Double.isNaN(x)) {
            throw new IllegalArgumentException("Cannot add NaN");
        }
    }

    public abstract void compress();

    public abstract long size();

    public abstract double cdf(double var1);

    public abstract double quantile(double var1);

    public abstract Collection<Centroid> centroids();

    public abstract double compression();

    public abstract int byteSize();

    public abstract int smallByteSize();

    public abstract void asBytes(ByteBuffer var1);

    public abstract void asSmallBytes(ByteBuffer var1);

    public abstract TDigest recordAllData();

    public abstract boolean isRecording();

    public abstract void add(double var1);

    public abstract void add(TDigest var1);
}

